<?php
require_once('Player.php');
require_once('Game.php');

class Result
{
	private $id;
	private $player;
	private $game;
	private $opponent;
	private $ges;
	private $abr;
	private $fehl;
	private $count;
	private $oges;
	private $oabr;
	private $ofehl;
	private $ocount;
	
	public function __construct($id, $player, $game, $opponent, $ges, $abr, $fehl, $count, $oges, $oabr, $ofehl, $ocount)
	{
		if (is_numeric($id) &&
		($player instanceof Player) &&
		($game instanceof Game) &&
		is_string($opponent) &&
		is_numeric($ges) &&
		is_numeric($abr) &&
		is_numeric($fehl) &&
		is_bool((boolean)$count) &&
		is_numeric($oges) &&
		is_numeric($oabr) &&
		is_numeric($ofehl) &&
		is_bool((boolean)$ocount)) {
			$this->id = $id;
			$this->player = $player;
			$this->game = $game;
			$this->opponent = $opponent;
			$this->ges = $ges;
			$this->abr = $abr;
			$this->fehl = $fehl;
			$this->count = (boolean)$count;
			$this->oges = $oges;
			$this->oabr = $oabr;
			$this->ofehl = $ofehl;
			$this->ocount = (boolean)$ocount;
		} else {
			$this->id = 0;
			$this->player = new Player(0, "default");
			$this->game = new Game(0, new Team(0, "default"), "default_op", new DateTime(), false);
			$this->opponent = "default_op";
			$this->ges = 0;
			$this->abr = 0;
			$this->fehl = 0;
			$this->count = false;
			$this->oges = 0;
			$this->oabr = 0;
			$this->ofehl = 0;
			$this->ocount = false;
		}
	}
	
	public function getId()
	{
		return $this->id;
	}
	public function getPlayer()
	{
		return $this->player;
	}
	public function getGame()
	{
		return $this->game;
	}
	public function getOpponent()
	{
		return $this->opponent;
	}
	public function getGes()
	{
		return $this->ges;
	}
	public function getAbr()
	{
		return $this->abr;
	}
	public function getFehl()
	{
		return $this->fehl;
	}
	public function getVoll()
	{
		return $this->ges - $this->abr;
	}
	public function getCount()
	{
		return $this->count;
	}
	public function getOGes()
	{
		return $this->oges;
	}
	public function getOAbr()
	{
		return $this->oabr;
	}
	public function getOVoll()
	{
		return $this->oges - $this->oabr;
	}
	public function getOFehl()
	{
		return $this->ofehl;
	}
	public function getOCount()
	{
		return $this->ocount;
	}
}
?>