<?php
require_once('Team.php');
require_once('Saison.php');
require_once('Player.php');

class PlayerToTeam
{
	private $id;
	private $player;
	private $saison;
	private $team;
	
	public function __construct($id, $player, $saison, $team)
	{
		if (is_numeric($id) && ($player instanceof Player) && ($saison instanceof Saison) && ($team instanceof Team)) {
			$this->id = $id;
			$this->player = $player;
			$this->team = $team;
			$this->saison = $saison;
		} else {
			$this->id = 0;
			$this->player = new Player(0, "default");
			$this->team = new Team(0, "default");
			$this->saison = new Saison(0, "default", new DateTime(), new DateTime());
		}
	}
	
	public function getId()
	{
		return $this->id;
	}
	
	public function getSaison()
	{
		return $this->saison;
	}
	
	public function getPlayer()
	{
		return $this->player;
	}
	
	public function getTeam()
	{
		return $this->team;
	}
}
?>