<?php
if (!isset($gCms)) exit;
require_once("lib/Classes/PHPExcel.php");

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "xlsteamtable" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/


$linktypes = array('xls', 'xlsx', 'pdf', 'ics');

/* Webanfrage wurde gestartet, daher zurückgeben des angeklickten Links */
if (isset($_POST['xlslinktype'])) {

	/* search for team inside the database */
	$teams = DatabaseOperations::getAllTeams();
	foreach ($teams as $tempteam) {
		if ($tempteam->getId() == $_POST['xlsteamid']) {
			$team = $tempteam;
		}
	}

	/* search for saison inside the database */
	$saisons = DatabaseOperations::getAllSaisons();
	foreach ($saisons as $tempsaison) {
		if ($tempsaison->getId() == $_POST['xlssaisonid']) {
			$saison = $tempsaison;
		}
	}

	/* search for linktype */
	foreach ($linktypes as $templinktype) {
		if ($templinktype == $_POST['xlslinktype']) {
			$linktype = $templinktype;
		}
	}

	/* content types für linktype definieren */
	$contenttype['xls'] = "application/vnd.ms-excel";
	$contenttype['xlsx'] = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
	$contenttype['pdf'] = "application/pdf";
	$contenttype['ics'] = "text/calendar";

	if (isset($saison) && isset($team) && isset($linktype)) {
		/* alle Spiele der Mannschaft holen und Ergebnisse berechnen */
		$games = DatabaseOperations::getTimeTable($saison, $team);
		$tableinfo = array();
		$i = 0;
		foreach ($games as $tempgame) {
			$tempresults = DatabaseOperations::getResultOfGame($tempgame);
			$tempcompresult['home'] = 0;
			$tempcompresult['opponent'] = 0;
			foreach ($tempresults as $tempresult) {
				$tempcompresult['home'] += $tempresult->getGes();
				$tempcompresult['opponent'] += $tempresult->getOGes();
			}
			$tableinfo[$i]['GameOurTeam'] = $tempgame->getOurTeam()->getName();
			$tableinfo[$i]['GameOpponent'] = $tempgame->getOpponent();
			$tableinfo[$i]['GameDate'] = $tempgame->getDate();
			$tableinfo[$i]['GameHome'] = $tempgame->getHome();
			$tableinfo[$i]['OurScore'] = $tempcompresult['home'];
			$tableinfo[$i]['OpponentScore'] = $tempcompresult['opponent'];
			$i += 1;
		}

		if ($linktype != 'ics') {
			/* data Array für CMS Excel erzeugen */
			for ($i = 0; $i < count($tableinfo); $i = $i + 1) {
				$data[$team->getName()][$i][0] = PHPExcel_Shared_Date::PHPToExcel($tableinfo[$i]['GameDate']);
				$data[$team->getName()][$i][1] = PHPExcel_Shared_Date::PHPToExcel($tableinfo[$i]['GameDate']);
				if ($tableinfo[$i]['GameHome'] == true) {
					$data[$team->getName()][$i][2] = $tableinfo[$i]['GameOurTeam'];
					$data[$team->getName()][$i][3] = $tableinfo[$i]['GameOpponent'];
					if ($tableinfo[$i]['OurScore'] == 0) {
						$data[$team->getName()][$i][4] = "";
					} else {
						$data[$team->getName()][$i][4] = $tableinfo[$i]['OurScore'];
					}
					$data[$team->getName()][$i][5] = ":";
					if ($tableinfo[$i]['OpponentScore'] == 0) {
						$data[$team->getName()][$i][6] = "";
					} else {
						$data[$team->getName()][$i][6] = $tableinfo[$i]['OpponentScore'];
					}
				} else {
					$data[$team->getName()][$i][2] = $tableinfo[$i]['GameOpponent'];
					$data[$team->getName()][$i][3] = $tableinfo[$i]['GameOurTeam'];
					if ($tableinfo[$i]['OpponentScore'] == 0) {
						$data[$team->getName()][$i][4] = "";
					} else {
						$data[$team->getName()][$i][4] = $tableinfo[$i]['OpponentScore'];
					}
					$data[$team->getName()][$i][5] = ":";
					if ($tableinfo[$i]['OurScore'] == 0) {
						$data[$team->getName()][$i][6] = "";
					} else {
						$data[$team->getName()][$i][6] = $tableinfo[$i]['OurScore'];
					}
				}
			}

			/* Neue Excelinstanz und die sheets erzeugen */
			$excelReader = PHPExcel_IOFactory::createReaderForFile(dirname(__FILE__)."/templates/Spielplan.xls");
			$excelObj = $excelReader->load(dirname(__FILE__)."/templates/Spielplan.xls");
			$a5sheet = $excelObj->getSheetByName("A5");
			$a5sheet->setTitle($team->getName()." - A5");
			$pocketsheet = $excelObj->getSheetByName("ID1");
			$pocketsheet->setTitle($team->getName()." - ID1");

			/* Daten in Excel Sheet A5 befüllen */
			$a5sheet->getCellByColumnAndRow(0,1)->setValue($this->Lang('date_frontend'));
			$a5sheet->getCellByColumnAndRow(1,1)->setValue($this->Lang('time_frontend'));
			$a5sheet->getCellByColumnAndRow(2,1)->setValue($this->Lang('home'));
			$a5sheet->getCellByColumnAndRow(3,1)->setValue($this->Lang('guest'));
			$a5sheet->getCellByColumnAndRow(4,1)->setValue($this->Lang('result'));
			$a5sheet->getCellByColumnAndRow(0,2)->setValue($this->Lang('firstround'));
			$a5sheet->getCellByColumnAndRow(0,14)->setValue($this->Lang('secondround'));
			for ($j = 0; $j < count($data[$team->getName()])/2; $j = $j + 1) {
				for ($i = 0; $i < 7; $i = $i + 1) {
					$a5sheet->getCellByColumnAndRow($i,$j+3)->setValue($data[$team->getName()][$j][$i]);
				}
			}
			for ($j = count($data[$team->getName()])/2; $j < count($data[$team->getName()]); $j = $j + 1) {
				for ($i = 0; $i < 7; $i = $i + 1) {
					$a5sheet->getCellByColumnAndRow($i,($j-count($data[$team->getName()])/2)+15)->setValue($data[$team->getName()][$j][$i]);
				}
			}

			/* Daten in Pocketsheet befüllen */
			$pocketsheet->getCellByColumnAndRow(0,1)->setValue($this->Lang('date_frontend'));
			$pocketsheet->getCellByColumnAndRow(1,1)->setValue($this->Lang('time_frontend'));
			$pocketsheet->getCellByColumnAndRow(2,1)->setValue($this->Lang('home'));
			$pocketsheet->getCellByColumnAndRow(3,1)->setValue($this->Lang('guest'));
			$pocketsheet->getCellByColumnAndRow(4,1)->setValue($this->Lang('result'));
			$pocketsheet->getCellByColumnAndRow(0,13)->setValue($this->Lang('date_frontend'));
			$pocketsheet->getCellByColumnAndRow(1,13)->setValue($this->Lang('time_frontend'));
			$pocketsheet->getCellByColumnAndRow(2,13)->setValue($this->Lang('home'));
			$pocketsheet->getCellByColumnAndRow(3,13)->setValue($this->Lang('guest'));
			$pocketsheet->getCellByColumnAndRow(4,13)->setValue($this->Lang('result'));
			for ($j = 0; $j < count($data[$team->getName()])/2; $j = $j + 1) {
				for ($i = 0; $i < 7; $i = $i + 1) {
					$pocketsheet->getCellByColumnAndRow($i,$j+2)->setValue($data[$team->getName()][$j][$i]);
				}
			}
			for ($j = count($data[$team->getName()])/2; $j < count($data[$team->getName()]); $j = $j + 1) {
				for ($i = 0; $i < 7; $i = $i + 1) {
					$pocketsheet->getCellByColumnAndRow($i,($j-count($data[$team->getName()])/2)+14)->setValue($data[$team->getName()][$j][$i]);
				}
			}
		} else {
			/* Data Array für ics erzeugen */
			for ($i = 0; $i < count($tableinfo); $i = $i + 1) {
				$data[$team->getName()][$i]['datestart'] = $tableinfo[$i]['GameDate']->format('Ymd\THis');
				$tempdate = $tableinfo[$i]['GameDate']->add(new DateInterval('PT3H'));
				$data[$team->getName()][$i]['dateend'] = $tempdate->format('Ymd\THis');
				$tempdate = new DateTime();
				$data[$team->getName()][$i]['datestamp'] = $tempdate->format('Ymd\THis');
				$data[$team->getName()][$i]['location'] =  "";
				$data[$team->getName()][$i]['description'] = "";
				if ($tableinfo[$i]['GameHome'] == false) {
					$data[$team->getName()][$i]['summary'] = $tableinfo[$i]['GameOpponent']." - ".$tableinfo[$i]['GameOurTeam'];
					$data[$team->getName()][$i]['description'] .= $this->Lang('homegame');
				} else {
					$data[$team->getName()][$i]['summary'] = $tableinfo[$i]['GameOurTeam']." - ".$tableinfo[$i]['GameOpponent'];
					$data[$team->getName()][$i]['description'] .= $this->Lang('awaygame');
				}
				$data[$team->getName()][$i]['description'] .= "; ".$this->Lang('hometeam').": ".$tableinfo[$i]['GameOurTeam'];
				$data[$team->getName()][$i]['description'] .= "; ".$this->Lang('awayteam').": ".$tableinfo[$i]['GameOpponent'];
				$tempstring = $data[$team->getName()][$i]['datestart'];
				$tempstring .= $tableinfo[$i]['GameOurTeam'];		
				$tempstring .= $tableinfo[$i]['GameOpponent'];
				$data[$team->getName()][$i]['md5sum'] = md5($tempstring);
			}
			$this->smarty->assign('data', $data);
		}
		
		/* XXX: Dirty hack - kill all php output buffers to prevent output */
		$outputhandlers = ob_list_handlers();
		for ($i = 0; $i < count($outputhandlers); $i = $i + 1) {
			ob_end_clean();
		}
		
		/* HTTP Header erzeugen */
		ob_start();
		header('Content-Type: '.$contenttype[$linktype]);
		header('Content-Disposition: attachment;filename="'.$team->getName().'.'.$linktype.'"');
		header('Cache-Control: max-age=0');

		/* Daten einfüllen */
		if ($linktype != 'ics') {
			if ($linktype == 'xls') {
				$excelWriter = PHPExcel_IOFactory::createWriter($excelObj, "Excel5");
			}
			if ($linktype == 'xlsx') {
				$excelWriter = PHPExcel_IOFactory::createWriter($excelObj, "Excel2007");
			}
			if ($linktype == 'pdf') {
				$excelWriter = PHPExcel_IOFactory::createWriter($excelObj, "PDF");
			}
			$excelWriter->save("php://output");
		} else {
			$icsString =  "BEGIN:VCALENDAR\n";
			$icsString .= "VERSION:2.0\n";
			$icsString .= "METHOD:PUBLISH\n";
			$icsString .= "PRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\n";
			$icsString .= "CALSCALE:GREGORIAN\n";
			foreach($data[$team->GetName()] as $game) {
				$icsString .= "BEGIN:VEVENT\n";
				$icsString .= "DTSTART:".$game['datestart']."\n";
				$icsString .= "DTEND:".$game['dateend']."\n";
				$icsString .= "DTSTAMP:".$game['datestamp']."\n";
				$icsString .= "LOCATION:".$game['location']."\n";
				$icsString .= "SUMMARY:".$game['summary']."\n";
				$icsString .= "SEQUENCE:0\n";
				$icsString .= "DESCRIPTION:".$game['description']."\n";
				$icsString .= "TRANSP:OPAQUE"."\n";
				$icsString .= "UID:".$game['md5sum']."\n";
				$icsString .= "END:VEVENT\n";
			}
			$icsString.= "END:VCALENDAR";
			$filehandle = fopen("php://output", "w");
			if ($filehandle != false) {
				fwrite($filehandle,$icsString);
			}
		}
		ob_end_flush();
		exit;
	}

	/* Es wurde keine Webanfrage gestellt, daher einfach mit Anzeige des Links fortfahren */
} else {
	/* search for team inside the database */
	$teams = DatabaseOperations::getAllTeams();
	foreach ($teams as $tempteam) {
		if ($tempteam->getName() == $params['team']) {
			$team = $tempteam;
		}
	}

	/* search for saison inside the database */
	$saisons = DatabaseOperations::getAllSaisons();
	foreach ($saisons as $tempsaison) {
		if ($tempsaison->getName() == $params['saison']) {
			$saison = $tempsaison;
		}
	}

	/* search for the type of link that should be created */
	foreach ($linktypes as $templinktype) {
		if ($templinktype == $params['linktype']) {
			$linktype = $templinktype;
		}
	}

	if (isset($saison) && isset($team) && isset($linktype)) {

		$this->smarty->assign('xlsformstart', $this->CreateFormStart("", "xlsteamtable"));
		$this->smarty->assign('xlsformlinktype', $this->CreateInputHidden("", "xlslinktype", $linktype));
		$this->smarty->assign('xlsformteamid', $this->CreateInputHidden("", "xlsteamid", $team->getId()));
		$this->smarty->assign('xlsformsaisonid', $this->CreateInputHidden("", "xlssaisonid", $saison->getId()));
		$this->smarty->assign('xlsformsubmit', $this->CreateInputSubmit("", "xlssubmit", $team->getName().".".$linktype));
		$this->smarty->assign('xlsformend', $this->CreateFormEnd());

		echo $this->ProcessTemplate('xlslink.tpl');
	} else {
		$this->smarty->assign('title_error', $this->Lang('errortag'));
		$this->smarty->assign('message', $this->Lang('error_team').$params['team']."<br/>".$this->Lang('error_saison').$params['saison']."<br/>".$this->Lang('error_linktype').$params['linktype']);
		echo $this->ProcessTemplate('error.tpl');
	}
}

?>
