<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "showteamtable" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/
/* search for team inside the database */
if ($params['team'] == 'all') {
        $team = 'all';
} else {
        $teams = DatabaseOperations::getAllTeams();
        foreach ($teams as $tempteam) {
                if ($tempteam->getName() == $params['team']) {
                        $team = $tempteam;
                }
        }
}

/* search for saison inside the database */
$saisons = DatabaseOperations::getAllSaisons();
foreach ($saisons as $tempsaison) {
	if ($tempsaison->getName() == $params['saison']) {
		$saison = $tempsaison;
	}
}

/* all links used by the xlslink parameter */
$links = array('xls' => false, 'xlsx' => false, 'pdf' => false, 'ics' => false);

/* check if links should be displayed */
if (strpos($params['xlslink'], 'none') == false) {
	$temparray = split(',',$params['xlslink']);
	foreach ($temparray as $key) {
		if (isset($links[$key])) {
			$links[$key] = true;
		}
	}
}


if (isset($saison) && isset($team)) {
	/* alle Spiele der Mannschaft holen und Ergebnisse berechnen */
	if ($team == 'all') {
                $games = DatabaseOperations::getTimeTable($saison);
        } else {
                $games = DatabaseOperations::getTimeTable($saison, $team);
        }
	$tableinfo = array();
	$i = 0;
	foreach ($games as $tempgame) {
		$tempresults = DatabaseOperations::getResultOfGame($tempgame);
		$tempcompresult['home'] = 0;
		$tempcompresult['opponent'] = 0;
		foreach ($tempresults as $tempresult) {
			$tempcompresult['home'] += $tempresult->getGes();
			$tempcompresult['opponent'] += $tempresult->getOGes();
		}
		$tableinfo[$i]['GameOurTeam'] = $tempgame->getOurTeam()->getName();
		$tableinfo[$i]['GameOpponent'] = $tempgame->getOpponent();
		$tableinfo[$i]['GameDate'] = $tempgame->getDate()->format("d.m.Y");
		$tableinfo[$i]['GameTime'] = $tempgame->getDate()->format("H:i");
		$tableinfo[$i]['GameHome'] = $tempgame->getHome();
		$tableinfo[$i]['OurScore'] = $tempcompresult['home'];
		$tableinfo[$i]['OpponentScore'] = $tempcompresult['opponent'];
		$i += 1;
	}
	$this->smarty->assign('Saison', $saison->getName());
	if ($team == 'all') {
	  $this->smarty->assign('Team', $this->Lang('allteams'));
	} else {
	  $this->smarty->assign('Team', $team->getName());
	}
	$this->smarty->assign('Results', $tableinfo);
	$this->smarty->assign('TagDate', $this->Lang('date'));
	$this->smarty->assign('TagTime', $this->Lang('time'));
	$this->smarty->assign('TagHome', $this->Lang('home'));
	$this->smarty->assign('TagGuest', $this->Lang('guest'));
	$this->smarty->assign('TagResult', $this->Lang('result'));
	$this->smarty->assign('ShowLinkToGameTag', $this->Lang('display'));
	$this->smarty->assign('ShowLinkToGame', $params['showlink']);
	foreach ($links as $key => $value) {
		$this->smarty->assign($key, $value);
	}
	echo $this->ProcessTemplate('showtimetable.tpl');
} else {
	$this->smarty->assign('title_error', $this->Lang('errortag'));
	$this->smarty->assign('message', $this->Lang('error_team').'<br/>'.$params['team'].$this->Lang('error_saison').$params['saison']);
	echo $this->ProcessTemplate('error.tpl');
}

?>