<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "showlatestresults" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

/* check for existing team in database */
if (isset($params['team'])) {
	$teams = DatabaseOperations::getAllTeams();
	foreach ($teams as $tempteam) {
		if ($tempteam->getName() == $params['team']) {
			$team = $tempteam;
		}
	}
} else {
	$team = NULL;
}

/* check if parameter days is given correctly */
if (isset($params['days'])) {
	$days = $params['days'];
} else {
	$days = 0;
}

/* alle Spiele holen und Ergebnisse berechnen */
$games = DatabaseOperations::getTimeTableTimediff($days, $team);
$tableinfo = array();
$i = 0;
foreach ($games as $tempgame) {
	$tempresults = DatabaseOperations::getResultOfGame($tempgame);
	$tempcompresult['home'] = 0;
	$tempcompresult['opponent'] = 0;
	foreach ($tempresults as $tempresult) {
		$tempcompresult['home'] += $tempresult->getGes();
		$tempcompresult['opponent'] += $tempresult->getOGes();
	}
	$tableinfo[$i]['GameOurTeam'] = $tempgame->getOurTeam()->getName();
	$tableinfo[$i]['GameOpponent'] = $tempgame->getOpponent();
	$tableinfo[$i]['GameDate'] = $tempgame->getDate()->format("d.m.Y");
	$tableinfo[$i]['GameTime'] = $tempgame->getDate()->format("H:i");
	$tableinfo[$i]['GameHome'] = $tempgame->getHome();
	$tableinfo[$i]['OurScore'] = $tempcompresult['home'];
	$tableinfo[$i]['OpponentScore'] = $tempcompresult['opponent'];
	$i += 1;
}
if ($team == NULL) {
	$this->smarty->assign('Team', $this->Lang('allteams'));
} else {
	$this->smarty->assign('Team', $team->getName());
}
$this->smarty->assign('NumberOfGames', $i);
$this->smarty->assign('Results', $tableinfo);
$this->smarty->assign('TagDate', $this->Lang('date'));
$this->smarty->assign('TagTime', $this->Lang('time'));
$this->smarty->assign('TagHome', $this->Lang('home'));
$this->smarty->assign('TagGuest', $this->Lang('guest'));
$this->smarty->assign('TagResult', $this->Lang('result'));
$this->smarty->assign('ShowLinkToGameTag', $this->Lang('display'));
$this->smarty->assign('ShowLinkToGame', $params['showlink']);
$this->smarty->assign('NoResult', $this->Lang('noresult'));
$this->smarty->assign('NoGames', $this->Lang('nogames'));
echo $this->ProcessTemplate('showlatestresults.tpl');

?>