<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess('Kegelergebnisse'))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "defaultadmin" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/
$curtab = $_POST['active_tab'];

$this->smarty->assign('tab_headers',$this->StartTabHeaders().
$this->SetTabHeader('saison',$this->Lang('title_saison'), ('saison'==$curtab) ? true:false).
$this->SetTabHeader('spieler',$this->Lang('title_spieler'), ('spieler'==$curtab) ? true:false).
$this->SetTabHeader('mannschaft',$this->Lang('title_mannschaft'), ('mannschaft'==$curtab) ? true:false).
$this->SetTabHeader('spielplan',$this->Lang('title_spielplan'), ('spielplan'==$curtab) ? true:false).
$this->EndTabHeaders().$this->StartTabContent());
$this->smarty->assign('end_tab',$this->EndTab());
$this->smarty->assign('tab_footers',$this->EndTabContent());
$this->smarty->assign('start_saison_tab',$this->StartTab('saison'));
$this->smarty->assign('start_spieler_tab',$this->StartTab('spieler'));
$this->smarty->assign('start_mannschaft_tab',$this->StartTab('mannschaft'));
$this->smarty->assign('start_spielplan_tab',$this->StartTab('spielplan'));

/* smarty tags for player tab */
$players = DatabaseOperations::getAllPlayers();
$playercontent = array();
foreach($players as $player) {
	$playercontent[$player->getId()]['PlayerFormChangeStart'] = $this->CreateFormStart($player->getId(),"changePlayer");
	$playercontent[$player->getId()]['PlayerFormChangeText'] = $this->CreateInputText("","playerchange_name", $player->getName(), 50, 50);
	$playercontent[$player->getId()]['PlayerFormChangeSubmit'] = $this->CreateInputSubmit("","playerchange_submit",$this->Lang('change'));
	$playercontent[$player->getId()]['PlayerFormChangeStop'] = $this->CreateFormEnd();
	$playercontent[$player->getId()]['PlayerName'] = $player->getName();
}
$this->smarty->assign('PlayerFormAddStart',$this->CreateFormStart("","addPlayer"));
$this->smarty->assign('PlayerFormAddText',$this->CreateInputText("","playeradd_name", "", 50, 50));
$this->smarty->assign('PlayerFormAddSubmit',$this->CreateInputSubmit("","playeradd_submit",$this->Lang('add')));
$this->smarty->assign('PlayerFormAddStop',$this->CreateFormEnd());
$this->smarty->assign('playername_header',$this->Lang('playername_header'));
$this->smarty->assign('playeraction_header',$this->Lang('playeraction_header'));
$this->smarty->assign('players',$playercontent);
$this->smarty->assign('activetab_spieler',$this->CreateInputHidden("","active_tab","spieler"));
$this->smarty->assign('PlayerDescAll', $this->Lang('allPlayers'));

/* smarty tags for teams tab */
$teams = DatabaseOperations::getAllTeams();
$teamcontent = array();
foreach($teams as $team) {
	$teamcontent[$team->getId()]['TeamFormChangeStart'] = $this->CreateFormStart($team->getId(),"changeTeam");
	$teamcontent[$team->getId()]['TeamFormChangeText'] = $this->CreateInputText("","teamchange_name", $team->getName(), 50, 50);
	$teamcontent[$team->getId()]['TeamFormChangeSubmit'] = $this->CreateInputSubmit("","teamchange_submit",$this->Lang('change'));
	$teamcontent[$team->getId()]['TeamFormChangeStop'] = $this->CreateFormEnd();
	$teamcontent[$team->getId()]['TeamName'] = $team->getName();
}
$this->smarty->assign('TeamFormAddStart',$this->CreateFormStart("","addTeam"));
$this->smarty->assign('TeamFormAddText',$this->CreateInputText("","teamadd_name", "", 50, 50));
$this->smarty->assign('TeamFormAddSubmit',$this->CreateInputSubmit("","teamadd_submit",$this->Lang('add')));
$this->smarty->assign('TeamFormAddStop',$this->CreateFormEnd());
$this->smarty->assign('teamname_header',$this->Lang('teamname_header'));
$this->smarty->assign('teamaction_header',$this->Lang('teamaction_header'));
$this->smarty->assign('teams',$teamcontent);
$this->smarty->assign('activetab_mannschaft',$this->CreateInputHidden("","active_tab","mannschaft"));

/* smarty tags for saisons tab */
$saisons = DatabaseOperations::getAllSaisons();
$saisoncontent = array();
foreach($saisons as $saison) {
	$saisoncontent[$saison->getId()]['SaisonFormChangeStart'] = $this->CreateFormStart($saison->getId(),"changeSaison");
	$saisoncontent[$saison->getId()]['SaisonFormChangeName'] = $this->CreateInputText("","saisonchange_name", $saison->getName(), 20, 20);
	$saisoncontent[$saison->getId()]['SaisonFormChangeBegin'] = $this->CreateInputText("","saisonchange_begin", $saison->getBegin()->format("d.m.Y H:i"), 20, 20);
	$saisoncontent[$saison->getId()]['SaisonFormChangeEnd'] = $this->CreateInputText("","saisonchange_end", $saison->getEnd()->format("d.m.Y H:i"), 20, 20);
	$saisoncontent[$saison->getId()]['SaisonFormChangeSubmit'] = $this->CreateInputSubmit("","saisonchange_submit",$this->Lang('change'));
	$saisoncontent[$saison->getId()]['SaisonFormChangeStop'] = $this->CreateFormEnd();
	$saisoncontent[$saison->getId()]['TeamName'] = "";
	$saisoncontent[$saison->getId()]['SaisonLinkPlayerConnection'] = $this->CreateLink($saison->getId(),"EditPlayerToTeam","",$this->Lang('playertoteam'));
}
$this->smarty->assign('SaisonFormAddStart', $this->CreateFormStart("", "addSaison"));
$this->smarty->assign('SaisonFormAddName', $this->CreateInputText("","saisonadd_name", "", 20, 20));
$this->smarty->assign('SaisonFormAddBegin', $this->CreateInputText("","saisonadd_begin", "", 20, 20));
$this->smarty->assign('SaisonFormAddEnd', $this->CreateInputText("","saisonadd_end", "", 20, 20));
$this->smarty->assign('SaisonFormAddSubmit', $this->CreateInputSubmit("","saisonadd_submit",$this->Lang('add')));
$this->smarty->assign('SaisonFormAddStop', $this->CreateFormEnd());
$this->smarty->assign('saisonname_header',$this->Lang('saisonname_header'));
$this->smarty->assign('saisonaction_header',$this->Lang('saisonaction_header'));
$this->smarty->assign('saisons',$saisoncontent);
$this->smarty->assign('activetab_saison',$this->CreateInputHidden("","active_tab","saison"));

/* smarty tags for spielplan tab */
$saisonlist = array();
$saisonselected = -1;
$saisonindex = 0;
foreach($saisons as $saison) {
	$saisonlist[$saison->getName()] = $saison->getId();
	if ($_POST['spielplan_saison'] == $saison->getId()) {
		$saisonselected = $saisonindex;
	}
	$saisonindex = $saisonindex + 1;
}
$teamlist = array();
$teamselected = -1;
$teamindex = 0;
foreach($teams as $team) {
	$teamlist[$team->getName()] = $team->getId();
	if ($_POST['spielplan_team'] == $team->getId()) {
		$teamselected = $teamindex;
	}
	$teamindex = $teamindex + 1;
}
$this->smarty->assign('SpielplanChooseFormStart', $this->CreateFormStart("", "defaultadmin"));
$this->smarty->assign('SpielplanChooseFormSaisonSelect', $this->CreateInputDropdown("", "spielplan_saison", $saisonlist, $saisonselected));
$this->smarty->assign('SpielplanChooseFormSaisonLabel', $this->Lang('saisonlabel'));
$this->smarty->assign('SpielplanChooseFormTeamSelect', $this->CreateInputDropdown("", "spielplan_team", $teamlist, $teamselected));
$this->smarty->assign('SpielplanChooseFormTeamLabel', $this->Lang('teamlabel'));
$this->smarty->assign('SpielplanChooseFormSubmit', $this->CreateInputSubmit("", "", $this->Lang('load')));
$this->smarty->assign('SpielplanChooseFormStop', $this->CreateFormEnd());
$this->smarty->assign('SpielplanTHopponent', $this->Lang('opponent'));
$this->smarty->assign('SpielplanTHdate', $this->Lang('date'));
$this->smarty->assign('SpielplanTHtime', $this->Lang('time'));
$this->smarty->assign('SpielplanTHhomeaway', $this->Lang('homeaway'));
$this->smarty->assign('SpielplanTHresult', $this->Lang('result'));
$this->smarty->assign('SpielplanTHaction', $this->Lang('action'));
$gamecontent = array();
if (($teamselected != -1) && ($saisonselected != -1)) {
	$saisonvalues = array_values($saisonlist);
	$this->smarty->assign('SpielplanSelectSaisonHidden',$this->CreateInputHidden("", "spielplan_saison", $saisonvalues[$saisonselected]));
	$teamvalues = array_values($teamlist);
	$this->smarty->assign('SpielplanSelectTeamHidden',$this->CreateInputHidden("", "spielplan_team", $teamvalues[$teamselected]));
	$team = DatabaseOperations::getTeam($teamvalues[$teamselected]);
	$saison = DatabaseOperations::getSaison($saisonvalues[$saisonselected]);
	$games = DatabaseOperations::getTimeTable($saison, $team);
	$tempFormAdd =  $this->CreateFormStart("id_addGame", "addGame");
	$tempFormAddId = preg_replace('/.*<form id="([^"]+)"(.*\n)*.*/', '${1}', $tempFormAdd);
	$this->smarty->assign('SpielplanGameAddStart', $tempFormAdd);
	$this->smarty->assign('SpielplanGameAddStop', $this->CreateFormEnd());
	$tempFormChange = $this->CreateFormStart("id_changeGame", "changeGame");
	$tempFormChangeId = preg_replace('/.*<form id="([^"]+)"(.*\n)*.*/', '${1}', $tempFormChange);
	$this->smarty->assign('SpielplanGameChangeStart', $tempFormChange);
	$this->smarty->assign('SpielplanGameChangeStop', $this->CreateFormEnd());
	foreach ($games as $game) {
		$gameresults = DatabaseOperations::getResultOfGame($game);
		$ourresult = 0;
		$theirresult = 0;
		foreach($gameresults as $gameresult) {
			$ourresult += $gameresult->getGes();
			$theirresult += $gameresult->getOGes();
		}
		if ($game->getHome()) {
			$gameresult = $ourresult." : ".$theirresult; 
		} else {
			$gameresult = $theirresult." : ".$ourresult;
		}
		$linkflags = array("spielplan_team" => $teamvalues[$teamselected], "spielplan_saison" => $saisonvalues[$saisonselected]);
		$gamecontent[$game->getId()]['SpielplanGameChangeResult'] = $this->CreateLink($game->getId(),"EditGame","",$gameresult,$linkflags);
		$gamecontent[$game->getId()]['SpielplanGameChangeGameIdHidden'] = $this->CreateInputHidden("", "gamechange_gameid", $game->getId());
		$gamecontent[$game->getId()]['SpielplanGameChangeHomeBool'] = $game->getHome();
		$gamecontent[$game->getId()]['SpielplanGameChangeDate'] = $this->CreateInputText("","gamechange_date", $game->getDate()->format("d.m.Y"), 10, 10);
		$gamecontent[$game->getId()]['SpielplanGameChangeTime'] = $this->CreateInputText("","gamechange_time", $game->getDate()->format("H:i"), 5, 5);
		$gamecontent[$game->getId()]['SpielplanGameChangeOpponent'] = $this->CreateInputText("","gamechange_opponent", $game->getOpponent(), 30, 30);
		$gamecontent[$game->getId()]['SpielplanGameChangeHome'] = $this->CreateInputCheckbox("","gamechange_home", true, $game->getHome());
		$gamecontent[$game->getId()]['SpielplanGameChangeSubmit'] = $this->CreateInputSubmit("","gamechange_submit", $this->Lang('change'), "onclick=\"submitForm(this, '".$tempFormChangeId."')\"");
	}
	$this->smarty->assign('SpielplanGameAddDate', $this->CreateInputText("","gameadd_date", "", 10, 10));
	$this->smarty->assign('SpielplanGameAddTime', $this->CreateInputText("","gameadd_time", "", 5, 5));
	$this->smarty->assign('SpielplanGameAddOpponent', $this->CreateInputText("","gameadd_opponent", "", 30, 30));
	$this->smarty->assign('SpielplanGameAddHome', $this->CreateInputCheckbox("","gameadd_home", true, false));
	$this->smarty->assign('SpielplanGameAddSubmit', $this->CreateInputSubmit("","gameadd_submit", $this->Lang('add'), "onclick=\"submitForm(this, '".$tempFormAddId."')\""));
}
$this->smarty->assign('games',$gamecontent);
$this->smarty->assign('activetab_spielplan',$this->CreateInputHidden("","active_tab","spielplan"));

echo $this->ProcessTemplate('adminpanel.tpl');
?>
