<?php
require_once('datamodel/databaseoperations.php');

if (!isset($gCms)) exit;
if (! $this->CheckAccess('Kegelergebnisse'))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}
/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "EditPlayerToTeam" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

/* Process Form data */
if (!isset($_GET['mact'])) {
	$_GET = $_SESSION['ppt_oldget'];
}
$mact_vars = explode(",", $_GET['mact']);
$saisonid = $mact_vars[1];

$_SESSION['ppt_oldget'] = $_GET;

/* get data from database */
$saison = DatabaseOperations::getSaison($saisonid);
$players = DatabaseOperations::getAllPlayers();
$teams = DatabaseOperations::getAllTeams();$playersarray = array();
$ptts = DatabaseOperations::getPlayersToTeam($saison);

/* Set common smarty tags */
$this->smarty->assign('pagetitle', $this->Lang('playertoteam')." - ".$saison->getName());
$this->smarty->assign('sortbyteam', $this->Lang('sortbyteam'));
$this->smarty->assign('sortbyplayer', $this->Lang('sortbyplayer'));
$this->smarty->assign('teamnameheader', $this->Lang('teamname_header'));
$this->smarty->assign('playernameheader', $this->Lang('playername_header'));
$this->smarty->assign('saisonid_hidden', $this->CreateInputHidden("", "ptt_saison", $saisonid));

/* create array for player dropbox */
$playersarray = array();
foreach($players as $player) {
	$playersarray[$player->getName()] = $player->getId();
}

/* create array for teams dropbox */
$teamsarray = array();
foreach($teams as $team) {
	$teamsarray[$team->getName()] = $team->getId();
}

/* create input fields that could be chagned */
$pttcontent = array();
foreach($ptts as $ptt) {
	/* create dropbox for player with the selected player */
	$tempplayerids = array_values($playersarray);
	$selectedplayer = -1;
	for ($i = 0; $i < count($tempplayerids); $i = $i + 1) {
		if ($tempplayerids[$i] == $ptt->getPlayer()->getId()) {
			$selectedplayer = $i;
		}
	}
	$pttcontent[$ptt->getId()]['PTTChangePlayerDrop'] = $this->CreateInputDropdown("","pttchange_player",$playersarray,$selectedplayer);
	
	/* create dropbox for team with the selected team */
	$tempteamids = array_values($teamsarray);
	$selectedteam = -1;
	for ($i = 0; $i < count($tempteamids); $i = $i + 1) {
		if ($tempteamids[$i] == $ptt->getTeam()->getId()) {
			$selectedteam = $i;
		}
	}
	$pttcontent[$ptt->getId()]['PTTChangeTeamDrop'] = $this->CreateInputDropdown("","pttchange_team",$teamsarray,$selectedteam);
	
	/* assign raw values */
	$pttcontent[$ptt->getId()]['PTTChangeTeamName'] = $ptt->getTeam()->getName();
	$pttcontent[$ptt->getId()]['PTTChangeTeamId'] = $ptt->getTeam()->getId();
	$pttcontent[$ptt->getId()]['PTTChangeTeamId_hidden'] = $this->CreateInputHidden("","pttchange_team",$ptt->getTeam()->getId());
	$pttcontent[$ptt->getId()]['PTTChangePlayerName'] = $ptt->getPlayer()->getName();
	$pttcontent[$ptt->getId()]['PTTChangePlayerId'] = $ptt->getPlayer()->getId();
	$pttcontent[$ptt->getId()]['PTTChangePlayerId_hidden'] = $this->CreateInputHidden("","pttchange_player",$ptt->getPlayer()->getId());
	
	/* create submit buttons */
	$pttcontent[$ptt->getId()]['PTTChangeSubmit'] = $this->CreateInputSubmit("", "pttchange_submit", $this->Lang('change'));
	$pttcontent[$ptt->getId()]['PTTChangeFormStart'] = $this->CreateFormStart($ptt->getId(), "changePlayerToTeam");
	$pttcontent[$ptt->getId()]['PTTChangeFormEnd'] = $this->CreateFormEnd();
}
$team_namehidden = array();
foreach ($teams as $tempteam) {
	$team_namehidden[$tempteam->getName()] = $this->CreateInputHidden("","pttadd_team",$tempteam->getId());
}
$this->smarty->assign('PTTChangeDataSet', $pttcontent);
$this->smarty->assign('PTTAddFormStart',  $this->CreateFormStart("new", "addPlayerToTeam"));
$this->smarty->assign('PTTAddFormEnd',  $this->CreateFormEnd());
$this->smarty->assign('PTTAddSubmit',  $this->CreateInputSubmit("", "pttchange_submit", $this->Lang('add')));
$this->smarty->assign('PTTAddPlayerDrop',  $this->CreateInputDropdown("","pttadd_player",$playersarray));
$this->smarty->assign('PTTAddTeamsDrop',  $this->CreateInputDropdown("","pttadd_team",$teamsarray));
$this->smarty->assign('PTTAddTeamsHidden', $team_namehidden);
$this->smarty->assign('PTTallteams', $teamsarray);
$this->smarty->assign('PTTallteamnames', array_keys($teamsarray));
$this->smarty->assign('PTTallteamids', array_values($teamsarray));
$this->smarty->assign('PTTallplayers', $playersarray);
$this->smarty->assign('PTTallplayernames', array_keys($playersarray));
$this->smarty->assign('PTTallplayerids', array_values($playersarray));

echo $this->ProcessTemplate('playertoteam.tpl');
?>