<?php
require_once('datamodel/databaseoperations.php');
if (!isset($gCms)) exit;
if (! $this->CheckAccess('Kegelergebnisse'))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}
/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for kegelergebnisse "EditGame" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

/* Process Post Things */
$mact_vars = explode(",", $_GET['mact']);
$gameid = $mact_vars[1];
$_SESSION['gameResult'] = $_GET;

/* fetch data from database */
$game = DatabaseOperations::getGame($gameid);
$results = Databaseoperations::getResultOfGame($game);

/* create array of players for selection */
$saisonid = $_GET[$gameid."spielplan_saison"];
$saison = DatabaseOperations::getSaison($saisonid);
$ptts = DatabaseOperations::getPlayersToTeam($saison);
$playersofteam = array();
$otherplayers = array();
/* first all players of the team */
foreach($ptts as $ptt) {
	if ($ptt->getTeam()->getId() == $game->getOurTeam()->getId()) {
		$playersofteam[$ptt->getPlayer()->getName()] = $ptt->getPlayer()->getId();
	}	else {
		$otherplayers[$ptt->getPlayer()->getName()] = $ptt->getPlayer()->getId();
	}
}
$playersarray = array_merge($playersofteam, $otherplayers);

/* create array of input fields for existing results */
$numberofresults = 0;
$formelements = array();
foreach($results as $result) 
{
	$formelements[$result->getId()]['GamePlayerSelection'] = $this->CreateInputDropdown("","game_player".$result->getId(),$playersarray,"-1",$result->getPlayer()->getId());
	$formelements[$result->getId()]['GameOpponent'] = $this->CreateInputText("","game_opponent".$result->getId(), $result->getOpponent(), 30, 30);
	$formelements[$result->getId()]['GameGes'] = $this->CreateInputText("","game_ges".$result->getId(), $result->getGes(), 5, 5);
	$formelements[$result->getId()]['GameAbr'] = $this->CreateInputText("","game_abr".$result->getId(), $result->getAbr(), 5, 5);
	$formelements[$result->getId()]['GameFehl'] = $this->CreateInputText("","game_fehl".$result->getId(), $result->getFehl(), 5, 5);
	$formelements[$result->getId()]['GameCount'] = $this->CreateInputCheckbox("","game_count".$result->getId(), true, $result->getCount());
	$formelements[$result->getId()]['GameOGes'] = $this->CreateInputText("","game_oges".$result->getId(), $result->getOGes(), 5, 5);
	$formelements[$result->getId()]['GameOAbr'] = $this->CreateInputText("","game_oabr".$result->getId(), $result->getOAbr(), 5, 5);
	$formelements[$result->getId()]['GameOFehl'] = $this->CreateInputText("","game_ofehl".$result->getId(), $result->getOFehl(), 5, 5);
	$formelements[$result->getId()]['GameOCount'] = $this->CreateInputCheckbox("","game_ocount".$result->getId(), true, $result->getOCount());
	$formelements[$result->getId()]['GameIndex'] = $this->CreateInputHidden("","game_index".$numberofresults, $result->getId());
	$numberofresults += 1;
}
for (;$numberofresults < 8; $numberofresults += 1) {
	$formelements["new".$numberofresults]['GamePlayerSelection'] = $this->CreateInputDropdown("","game_player_new".$numberofresults,$playersarray,"-1");
	$formelements["new".$numberofresults]['GameOpponent'] = $this->CreateInputText("","game_opponent_new".$numberofresults, "", 30, 30);
	$formelements["new".$numberofresults]['GameGes'] = $this->CreateInputText("","game_ges_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameAbr'] = $this->CreateInputText("","game_abr_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameFehl'] = $this->CreateInputText("","game_fehl_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameCount'] = $this->CreateInputCheckbox("","game_count_new".$numberofresults, true, true);
	$formelements["new".$numberofresults]['GameOGes'] = $this->CreateInputText("","game_oges_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameOAbr'] = $this->CreateInputText("","game_oabr_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameOFehl'] = $this->CreateInputText("","game_ofehl_new".$numberofresults, "", 5, 5);
	$formelements["new".$numberofresults]['GameOCount'] = $this->CreateInputCheckbox("","game_ocount_new".$numberofresults, true, true);
	$formelements["new".$numberofresults]['GameIndex'] = $this->CreateInputHidden("","game_index".$numberofresults, "new");
}
$this->smarty->assign('pagetitle', $saison->getName()." - ".$this->Lang('gameresult').": ".$game->getDate()->format("d.m.Y H:i"));
$this->smarty->assign('GameResults', $formelements);
$this->smarty->assign('GameOpponent', $game->getOpponent());
$this->smarty->assign('GameHomeTeam', $game->getOurTeam()->getName());
$this->smarty->assign('GameIsHome', $game->getHome());
$this->smarty->assign('GameFormStart', $this->CreateFormStart($game->getId(), "changeGameResult"));
$this->smarty->assign('GameFormEnd', $this->CreateFormEnd());
$this->smarty->assign('GameFormSubmit', $this->CreateInputSubmit("", "gameSubmit", $this->Lang('save')));

echo $this->ProcessTemplate('editgame.tpl');
?>