<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

$this->SetCurrentTab('settings');

$timeout = (int)$params['timeout'];
if( $timeout <= 0 )
  $timeout = '';
else if( $timeout < 10 )
  $timeout = 10;
$niters = (int)$params['max_autotask_iterations'];
$niters = min(20,max(1,$niters));

$n = (int)$params['cronjob_interval'];
$n = min(9999,max(0,$n));
$this->SetPreference('cronjob_interval',$n);
$n = (int)$params['escalation_intervallimit'];
$n = min(100,max(0,$n));
$this->GetPreference('escalation_intervallimit',$n);
$this->SetPreference('dflt_page',$params['dfltpage']);
$this->SetPreference('task_timeout',(int)$timeout);
$this->SetPreference('max_autotask_iterations',(int)$niters);

$slack = (float)$params['iterative_slack'];
$slack = min(max(0.25,$slack),5);
$this->SetPreference('iterative_slack',$slack);

$this->SetMessage($this->Lang('msg_prefsupdated'));
$this->RedirectToTab($id);
#
# EOF
#
?>