<p>This module extends the Global Settings with some customized parameters.<br />
You can define an unlimited number of fields which can be used as smarty-variable in templates or pages.</p>

<h3>Use of the module Custom Global Settings</h3>

<p>To start you have to add <b>{CustomGS}</b> in the top of your template(s).</p>

<p>
In the templates or pages of your website you will now have all smarty variables available that are defined in the Custom Global Settings module Fielddefinitions tab.<br />
The exact way to call each variable is shown in the fielddefinitions table. You can also check which variables and values are available by placing <b>{CustomGS showvars=1}</b> in the content field of a page.
</p>

<p>Warning: better not place the {CustomGS} tag in the &lt;head&gt; section of your template, because that's the last section that will be parsed by the Smarty templating system.</p>

<div style="border-bottom:1px dashed #999"></div>

<h3>Permissions</h3>
<p>This module provides two different permission groups:<p>
<p><b>1. Custom Global Settings - Use</b><br />
A permission to use for editors. It will only show the General tab in the admin page.</p>

<p><b>2. Custom Global Settings - Manage</b><br />
A permission to use for administrators. It will show all module tabs.</p>

<div style="border-bottom:1px dashed #999"></div>

<h3>Examples</h3>

<p>Define a checkbox 'Christmas now' which will activate a special theme on the frontend when checked</p>
<p style="border:1px solid #ddd; padding:10px; background-color:#f3f3f3">
<code>
{if $CustomGS.Christmas_now == '1'}<br />
&nbsp;&nbsp;&nbsp;{* Show Christmas frontend theme *}<br />
{else}<br />
&nbsp;&nbsp;&nbsp;{* Show default frontend theme *}<br />
{/if}
</code>
</p>
<br />

<p>Define a checkbox 'MyCheckbox' which will do some magic stuff when unchecked</p>
<p style="border:1px solid #ddd; padding:10px; background-color:#f3f3f3">
<code>
{if $CustomGS.MyCheckbox != '1'}<br />
&nbsp;&nbsp;&nbsp;{* Do some magic stuff *}<br />
{/if}
</code>
</p>
<br />

<p>Define a textfield or pulldown field 'Trainer' which will contain the current trainers name.</p>
<p style="border:1px solid #ddd; padding:10px; background-color:#f3f3f3">
<code>
&lt;p&gt;This weeks trainers name is: {$CustomGS.Trainer}&lt;/p&gt;
</code>
</p>
<br />

<p>Define two timepicker fields 'starttime' and 'endtime'. Replace the {content} tag in your page template with this code and the normal page content is only visible when the current time is between the starttime and endtime.</p>
<p style="border:1px solid #ddd; padding:10px; background-color:#f3f3f3">
<code>
{if $smarty.now|date_format:'%H:%M' >= $CustomGS.starttime && $smarty.now|date_format:'%H:%M' <= $CustomGS.endtime}<br />
&nbsp;&nbsp;&nbsp;{content}<br />
{else}<br />
&nbsp;&nbsp;&nbsp;{content block="SiteClosedContent"}<br />
{/if}<br />
</code>
</p>

<div style="border-bottom:1px dashed #999"></div>

<h3>More examples or help</h3>

<p>For more examples or help on this module, please check the <a href="http://wiki.cmsmadesimple.org/index.php/User_Handbook/Admin_Panel/Extensions/CustomGlobalSettings">CMSms Wiki page</a>.</p>

<div style="border-bottom:1px dashed #999"></div>

<h3>Copyright and License</h3>

<p>Copyright © 2012, Rolf Tjassens &lt;rolf at cmsmadesimple dot org&gt;, Jos &lt;<a href="mailto:josvd@live.nl">josvd@live.nl</a>&gt;. All Rights Are Reserved.</p>

<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License v3</a>. However, as a special exception to the GPL, this software is distributed as an addon module to CMS Made Simple. You may only use this software when there is a clear and obvious indication in the admin section that the site was built with CMS Made Simple.</p>

<div style="border-bottom:1px dashed #999"></div>
