<?php
#-------------------------------------------------------------------------
# Module: Custom Global Settings
# Author: Rolf Tjassens, Jos
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/customgs
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

if( !$this->CheckPermission('Custom Global Settings - Manage') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Custom Global Settings - Manage'));
	return;
}

if ( isset($params['cancel']) )
{
	$params = array('active_tab' => 'fielddefs');
	$this->Redirect($id, 'defaultadmin', '', $params);
}

if( !isset($params['mode']) )
{
	$params = array('module_error' => lang('missingparams'), 'active_tab' => 'fielddefs');
	$this->Redirect($id,'defaultadmin','',$params);
	return;
}

$db = $this->GetDB();

switch ($params['mode'])
{
	case 'add':
		if( $_SERVER['REQUEST_METHOD'] == 'POST' )
		{
			// check if name is empty
			if ( empty($params['name']) ) $params['name'] = $params['type'] . "1";
			// check if name already exists
			While ( $this->GetField($params['name']) !== FALSE )
			{
				if ( is_numeric(substr($params['name'], -1)) )
				{
					$params['name'] = is_numeric(substr($params['name'], -2)) ? substr($params['name'],0 , -2) . (substr($params['name'], -2) + 1) : substr($params['name'],0 , -1) . (substr($params['name'], -1) + 1);
				}
				else
				{
					$params['name'] .= "1";
				}
			}
			// find maximum value for sortorder
			$query = "SELECT MAX(sortorder) AS maxsortorder FROM ".cms_db_prefix()."module_customgs";
			$result = $db->Execute($query);
			if( $result )
			{
				$field = $result->FetchRow();
				// set properties, depending on fieldtype
				if( $params['type'] == 'textfield' )
				{
					$params['properties'] = is_numeric($params['maxlength']) ? $params['maxlength'] : 255;
				}
				elseif ( $params['type'] == 'textarea' || $params['type'] == 'wysiwyg' )
				{
					$params['properties'] = isset($params['parsesmarty']);
				}
				elseif ( $params['type'] != 'pulldown' && $params['type'] != 'radiobuttons' )
				{
					$params['properties'] = '';
				}
				$params['clearcache'] = isset($params['clearcache']);
				// save fielddefinition
				$query = "INSERT INTO ".cms_db_prefix()."module_customgs (name, help, type, properties, clearcache, sortorder) VALUES (?,?,?,?,?,?)";
				$result = $db->Execute($query, array($params['name'], $params['help'], $params['type'], $params['properties'], $params['clearcache'], $field['maxsortorder'] + 1));
			}
			if( isset($result) && $result )
			{
				// Put mention into the admin log
				audit($db->Insert_ID(), 'Custom Global Settings - Fielddefinition', 'Added: ' . $params['name']);
				$params = array('tab_message'=> 'fielddefadded', 'active_tab' => 'fielddefs');
			}
			else
			{
				$params = array('module_error'=> 'fielddefupdatefailed', 'active_tab' => 'fielddefs');
			}

			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		$field = array('name' => '', 'help' => '', 'type' => '', 'maxlength' => '', 'properties' => '', 'parsesmarty' => '', 'clearcache' => 0);
		$smarty->assign('title',lang('add'));
		$smarty->assign('hidden', $this->CreateInputHidden($id, 'mode', 'add'));
		break;


	case 'delete':
		if( !is_numeric($params['fieldid']) )
		{
			$params = array('module_error' => lang('missingparams'), 'active_tab' => 'fielddefs');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}
    $query = "SELECT name, sortorder FROM ".cms_db_prefix()."module_customgs WHERE fieldid = ?";
		$result = $db->Execute($query, array($params['fieldid']));
		if( !$result || $result->RecordCount() == 0 )
		{
			$params = array('module_error'=> 'fielddefupdatefailed', 'active_tab' => 'fielddefs');
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		$row = $result->FetchRow();

		$query = "DELETE FROM " . cms_db_prefix() . "module_customgs WHERE fieldid = ?";
		$db->Execute($query, array($params['fieldid']));
		// Put mention into the admin log
		audit($params['fieldid'], 'Custom Global Settings - Fielddefinition', 'Deleted: ' . $row['name']);

		// update the sortorder
		$query = "UPDATE " . cms_db_prefix() . "module_customgs SET sortorder = sortorder - 1 WHERE sortorder > ?";
		$result = $db->Execute($query, array($row['sortorder']));

		$params = array('tab_message'=> 'fielddefsupdated', 'active_tab' => 'fielddefs');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;


	case 'edit':
		if( !is_numeric($params['fieldid']) )
		{
			$params = array('module_error' => lang('missingparams'), 'active_tab' => 'fielddefs');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		if( $_SERVER['REQUEST_METHOD'] == 'POST' )
		{
			// check if name is empty
			if ( empty($params['name']) ) $params['name'] = $params['type'] . "1";
			// check if name already exists
			$checkfieldname = $this->GetField($params['name']);
			While ( $checkfieldname !== FALSE && $params['fieldid'] != $checkfieldname['fieldid'] )
			{
				if ( is_numeric(substr($params['name'], -1)) )
				{
					$params['name'] = is_numeric(substr($params['name'], -2)) ? substr($params['name'],0 , -2) . (substr($params['name'], -2) + 1) : substr($params['name'],0 , -1) . (substr($params['name'], -1) + 1);
				}
				else
				{
					$params['name'] .= "1";
				}
				$checkfieldname = $this->GetField($params['name']);
			}
			// set properties, depending on fieldtype
			if( $params['type'] == 'textfield' )
			{
				$params['properties'] = is_numeric($params['maxlength']) ? $params['maxlength'] : 255;
			}
			elseif ( $params['type'] == 'textarea' || $params['type'] == 'wysiwyg' )
			{
				$params['properties'] = $params['parsesmarty'];
			}
			elseif ( $params['type'] != 'pulldown' && $params['type'] != 'radiobuttons' )
			{
				$params['properties'] = '';
			}
			$params['clearcache'] = isset($params['clearcache']);

			// save fielddefinition
			$query = "UPDATE " . cms_db_prefix() . "module_customgs SET name = ?, help = ?, type = ?, properties = ?, clearcache = ? WHERE fieldid = ?";
			$result = $db->Execute($query, array($params['name'], $params['help'], $params['type'], $params['properties'], $params['clearcache'], $params['fieldid']));

			// Put mention into the admin log
			audit($params['fieldid'], 'Custom Global Settings - Fielddefinition', 'Edited: ' . $params['name']);

			$params = array('tab_message'=> 'fielddefsupdated', 'active_tab' => 'fielddefs');
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		$field = $this->GetField($params['fieldid']);

		$smarty->assign('title',lang('edit'));
		$smarty->assign('hidden', $this->CreateInputHidden($id, 'fieldid', $params['fieldid']) .
						$this->CreateInputHidden($id, 'mode', 'edit'));
		break;


	case 'moveup':
	case 'movedown':
		$query = "SELECT * FROM " . cms_db_prefix() . "module_customgs WHERE fieldid = ?";
		$result = $db->Execute($query, array($params['fieldid']));
		if( !$result || $result->RecordCount() == 0 )
		{
			$params = array('module_error'=> 'typeupdatefailed', 'active_tab' => 'types');
			$this->Redirect($id, 'defaultadmin', '', $params);
		}
		$row = $result->FetchRow();

		$query = "UPDATE " . cms_db_prefix() . "module_customgs SET sortorder = " . ($params['mode'] == 'moveup' ? 'sortorder + 1' : 'sortorder - 1') . " WHERE sortorder = ?";
		$result = $db->Execute($query, array($params['mode'] == 'moveup' ? $row['sortorder'] - 1 : $row['sortorder'] + 1));

		$query = "UPDATE " . cms_db_prefix() . "module_customgs SET sortorder = " . ($params['mode'] == 'moveup' ? 'sortorder - 1' : 'sortorder + 1') . " WHERE fieldid = ?";
		$result = $db->Execute($query, array($params['fieldid']));

		$params = array('active_tab' => 'fielddefs');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;

}


$typelist = array(
	$this->Lang('textfield') => 'textfield',
	$this->Lang('pulldown') => 'pulldown',
	$this->Lang('checkbox') => 'checkbox',
	$this->Lang('radiobuttons') => 'radiobuttons',
	$this->Lang('datepicker') => 'datepicker',
	$this->Lang('datetimepicker') => 'datetimepicker',
	$this->Lang('timepicker') => 'timepicker',
	$this->Lang('textarea') => 'textarea',
	$this->Lang('wysiwyg') => 'wysiwyg',
	$this->Lang('button') => 'button');

$smarty->assign('prompt_name',lang('name'));
$smarty->assign('name', $this->CreateInputText( $id, 'name', $field['name'], 40 ));

$smarty->assign('prompt_type', lang('type'));
$smarty->assign('type', $this->CreateInputDropdown($id, 'type', $typelist, -1, $field['type'], 'id="fieldtype"'));

$smarty->assign('prompt_maxlength',$this->Lang('maxlength'));
$smarty->assign('maxlength', $this->CreateInputText( $id, 'maxlength', $field['type'] == 'textfield' ? $field['properties'] : '', 5, 5));

$smarty->assign('prompt_properties', $this->Lang('properties'));
$smarty->assign('help_properties', $this->Lang('properties_help1'));
$smarty->assign('properties', $this->CreateTextArea(FALSE, $id, $field['type'] == 'pulldown' || $field['type'] == 'radiobuttons' ? $field['properties'] : '', 'properties', '', '' , '' , '', 20, 6, '', '', 'style="width:20em; height:6em;"'));

$smarty->assign('prompt_parsesmarty',$this->Lang('parsesmarty'));
$smarty->assign('parsesmarty', $this->CreateInputCheckbox($id, 'parsesmarty', '1', $field['type'] == 'textarea' || $field['type'] == 'wysiwyg' ? $field['properties'] : ''));

$smarty->assign('prompt_help', lang('help'));
$smarty->assign('help', $this->CreateInputText( $id, 'help', $field['help'], 80 ));

$smarty->assign('prompt_clearcache', $this->Lang('clearstylesheetcache'));
$smarty->assign('help_clearcache', $this->Lang('clearstylesheetcache_help'));
$smarty->assign('clearcache', $this->CreateInputCheckbox($id, 'clearcache', '1', $field['clearcache']));

$smarty->assign('submit',$this->CreateInputSubmit ($id, 'submitbutton', lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit ($id, 'cancel', lang('cancel')));

$smarty->assign('formstart', $this->CreateFormStart ($id, 'editfielddef', $returnid));
$smarty->assign('formend',$this->CreateFormEnd());

echo $this->ProcessTemplate('editfielddef.tpl');

?>