<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2010 by Duketown 
#
# This function supports deleting a row from the various tables
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

switch ($params['table'])
{
	case 'Maps':
		// Remove the polyline parts
		$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_polylineparts 
			WHERE polyline_id in (
				SELECT polyline_id FROM '.cms_db_prefix().'module_googlemaps_polylines 
				WHERE map_id= ?)';
		$db->Execute($query, array($params['map_id']) );
		// Remove the polyline
		$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_polylines 
			WHERE map_id = ?';
		$row = $db->GetRow( $query, array($params['map_id']) );
		// Remove the markers connected to the map (no referencial check!)
		$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_markers WHERE map_id = ?';
		$db->Execute($query, array($params['map_id']) );
		// Remove the map (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_maps WHERE map_id = ?';
		$row = $db->GetRow( $query, array($params['map_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_maps WHERE map_id = ?';
			$db->Execute($query, array($params['map_id']) );
			$params = array('tab_message'=> 'mapdeleted', 'active_tab' => 'maps');
		}
		break;
	case 'Markers':
		// Remove the marker (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_markers WHERE marker_id = ?';
		$row = $db->GetRow( $query, array($params['marker_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_markers WHERE marker_id = ?';
			$db->Execute($query, array($params['marker_id']) );
			$params = array('tab_message'=> 'markerdeleted', 'active_tab' => 'markers');
		}
		break;
	case 'Polylines':
		// Remove the polyline parts
		$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_polylineparts WHERE polyline_id = ?';
		$db->Execute($query, array($params['polyline_id']) );
		// Remove the polyline
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylines WHERE polyline_id = ?';
		$row = $db->GetRow( $query, array($params['polyline_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_polylines WHERE polyline_id = ?';
			$db->Execute($query, array($params['polyline_id']) );
			$params = array('tab_message'=> 'polylinedeleted', 'active_tab' => 'polylines');
		}
		break;
	case 'Polylineparts':
		// Remove the polyline part
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylineparts WHERE polylinepart_id = ?';
		$row = $db->GetRow( $query, array($params['polylinepart_id']) );
		$params['polyline_id'] = $row['polyline_id'];
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_googlemaps_polylineparts WHERE polylinepart_id = ?';
			$db->Execute($query, array($params['polylinepart_id']) );
		}
		$this->Redirect($id, 'editpolyline', $returnid, $params);
		break;

	default:
		break;
}

// redirect the user to the default admin screen
$this->Redirect($id, 'defaultadmin', $returnid, $params);

?>