<?php
$gCms = cmsms(); if( !is_object($gCms) ) exit;

$current_version = $oldversion;
switch($current_version)
{
 case "0.1.2":
   break;
 case "0.1.3":
   $dict = NewDataDictionary($db);

   #change map info to text
   $sqlarray = $dict->AlterColumnSQL(cms_db_prefix()."module_googlemaps_maps", "description X");
   $dict->ExecuteSQLArray($sqlarray);
   #change marker info to text
   $sqlarray = $dict->AlterColumnSQL(cms_db_prefix()."module_googlemaps_markers", "info X");
   $dict->ExecuteSQLArray($sqlarray);
   break;
 case "0.1.4":
   $dict = NewDataDictionary($db);

   #change map info to text
   $sqlarray = $dict->AlterColumnSQL(cms_db_prefix()."module_googlemaps_cache", "lat F");
   $dict->ExecuteSQLArray($sqlarray);
   
   $current_version = "0.1.4";
 case "0.1.4":
 	$config = $gCms->GetConfig();
	// Prepare a directory that will contain the images of the markers and one for the shadows of the markers
	$path = $this->config['uploads_path'].DIRECTORY_SEPARATOR.$this->getName();
	// Make sure the directory can be found. Create it, error handling will cover any problems found
	mkdir($path, 0777);
	$markerspath = $path.DIRECTORY_SEPARATOR.'markers';
	mkdir($markerspath, 0777);
	$markershadowspath = $path.DIRECTORY_SEPARATOR.'markershadows';
	mkdir($markershadowspath, 0777);
	// Copy over the default supplied markers
	$markerdir = dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'markers';
	if (file_exists( $markerdir ) ) {
		$dir = opendir($markerdir);
		// Filter out the directory controling characters and build selectable options of the others
		while (($file = readdir($dir)) !== false)
		  {
		  	if ($file !='.' && $file!='..') {
	  			copy($markerdir.DIRECTORY_SEPARATOR.$file, $markerspath.DIRECTORY_SEPARATOR.$file);
		  	}
		  }
		closedir($dir);
	}

	$current_version = "0.1.5";
 case "0.1.5":
	// No database changes. Only internal changes for the use of parameters   
	$current_version = "0.1.6";
 case "0.1.6":
 	$config = $gCms->GetConfig();
	// Prepare name of directory with old 2.0 API
	$APIdir = $this->config['root_url'].DIRECTORY_SEPARATOR.'modules'.
		DIRECTORY_SEPARATOR.$this->getName().
		DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'GoogleMapAPI-2.0';
	$path = $APIdir;
	// Clear the directory
	$handle = opendir($APIdir);
	while (FALSE !== ($entry = readdir($handle))) {
		if ($entry != '.' && $entry != '..')
		{
			if(!(substr($path,-1) == DIRECTORY_SEPARATOR))	$path .= DIRECTORY_SEPARATOR;
			$obj = $path.$entry;
			if (is_file($obj))
			{
				unlink($obj);					
			}
		}
	}
	closedir($handle);
	// Now that its clear, remove the directory
	if(is_dir($APIdir)) rmdir($APIdir);

	$dict = NewDataDictionary($db);
	$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_googlemaps_maps', 'zoomscrollwheel L' );
	$dict->ExecuteSQLArray($sqlarray);
	$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_googlemaps_maps', 'scale_control L' );
	$dict->ExecuteSQLArray($sqlarray);

	$current_version = '0.1.7';

 case '0.1.7':
	$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'easylocator.tpl';
	if( file_exists( $fn ) )
	{
		$template = @file_get_contents($fn);
		$this->SetTemplate( 'googlemaps_easylocator', $template, $this->GetName());
	}

	$this->SetPreference('easylocatorlevel', 1 );
	$this->SetPreference('easylocatorlat', 44 );
	$this->SetPreference('easylocatorlon', -63 );
	$this->SetPreference('easylocatorsavelast', '1' );
	$current_version = '0.1.8';
	
  case '0.1.8':
  	$dict = NewDataDictionary($db);
	// Prepare name of directory with old 2.5 API
	$APIdir = cms_join_path($this->config['root_url'],'modules',$this->getName(),
		'lib','GoogleMapAPI-2.5');
	$path = $APIdir;
	// Clear the directory
	$handle = opendir($APIdir);
	if ($handle) {
		while (FALSE !== ($entry = readdir($handle))) {
			if ($entry != '.' && $entry != '..')
			{
				if(!(substr($path,-1) == DIRECTORY_SEPARATOR))	$path .= DIRECTORY_SEPARATOR;
				$obj = $path.$entry;
				if (is_file($obj))
				{
					unlink($obj);					
				}
			}
		}
		closedir($handle);
		// Now that its clear, remove the directory
		if(is_dir($APIdir)) rmdir($APIdir);
	}

	// Polylines
	$flds = "
		polyline_id I KEY,
		map_id I,
		name C(80),
		strokecolor C(7),
		strokeopacity F,
		strokeweight I
	";

	// Create the table
	$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_polylines", $flds, $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);
	// Create a sequence
	$db->CreateSequence(cms_db_prefix()."module_googlemaps_polylines_seq");
	
	// Polyline parts
	$flds = "
		polylinepart_id I KEY,
		polyline_id I KEY,
		seq I,
		description C(255),
		lat C(100),
		lon C(100)
	";
	
	// Create the table
	$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_polylineparts", $flds, $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);
	// Create a sequence
	$db->CreateSequence(cms_db_prefix()."module_googlemaps_polylineparts_seq");
	$current_version = '0.1.9';
	
  case '0.1.9':
	$dict = NewDataDictionary($db);
	$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_googlemaps_polylines', 'distance F' );
	$dict->ExecuteSQLArray($sqlarray);
	$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_googlemaps_polylines', 'distanceuom C(1)' );
	$dict->ExecuteSQLArray($sqlarray);

	// Remove the Easylocator template (was not in use at all)
	$this->DeleteTemplate('googlemaps_easylocator');
	$this->SetPreference('easylocatorcursor', 'crosshair');
	// Prepare name of directory with easylocator template
	$obj = cms_join_path($this->config['root_url'],'modules',$this->getName(),
		'templates','easylocator.tpl');
	if (is_file($obj)) {
		@unlink($obj);					
	}
	$current_version = '0.2.0';
  case '0.2.0':
	$current_version = '0.2.1';

 default:
    break;
}

// put mention into the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded',$this->GetVersion()));

?>
