<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown 
#
# This function supports adding a polyline
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class googlemaps_utils
{
	function get_list_maps() {
		if ($itemnumber == -1) return false;
		
		$db = cmsms()->GetDb();
		$maplist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_maps 
			ORDER BY name';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$maplist[$row['name']] = $row['map_id'];
		}
		return $maplist;	

	}

	/* --------------------------------------------------------
		get_distance_uom()
		A function to return filled array with possible distance unit of measures
		--------------------------------------------------------*/	
	function get_distance_uom()
	{
		$distanceuomlist = array();
		$distanceuomlist[$this->Lang('uom_kilometer')] = 'K';
		$distanceuomlist[$this->Lang('uom_mile')] = 'M';
		$distanceuomlist[$this->Lang('uom_meter')] = 'T';
		$distanceuomlist[$this->Lang('uom_feet')] = 'F';
		$distanceuomlist[$this->Lang('uom_centimeter')] = 'C';
		$distanceuomlist[$this->Lang('uom_inch')] = 'I';
		$distanceuomlist[$this->Lang('uom_nauticalmile')] = 'N';
		
		return $distanceuomlist;
	}

	/* --------------------------------------------------------
		get_easylocatorcursorlist()
		A function to return filled array with possible cursors
		--------------------------------------------------------*/	
	function get_easylocatorcursorlist()
	{
		$easylocatorcursorlist = array();
		$easylocatorcursorlist[$this->Lang('easylocator_crosshair')] = 'crosshair';
		$easylocatorcursorlist[$this->Lang('easylocator_auto')] = 'auto';
		$easylocatorcursorlist[$this->Lang('easylocator_default')] = 'default';
		$easylocatorcursorlist[$this->Lang('easylocator_help')] = 'help';
		$easylocatorcursorlist[$this->Lang('easylocator_move')] = 'move';
		$easylocatorcursorlist[$this->Lang('easylocator_pointer')] = 'pointer';
		$easylocatorcursorlist[$this->Lang('easylocator_text')] = 'text';
		$easylocatorcursorlist[$this->Lang('easylocator_wait')] = 'wait';
		$easylocatorcursorlist[$this->Lang('easylocator_hand')] = 'hand';
		$easylocatorcursorlist[$this->Lang('easylocator_progress')] = 'progress';
		$easylocatorcursorlist[$this->Lang('easylocator_no')] = 'no';

		return $easylocatorcursorlist;
	}

	/* --------------------------------------------------------
		get_gpxexporttypelist()
		A function to return filled array with possible gpx route types
		--------------------------------------------------------*/	
	function get_gpxexporttypelist()
	{
		$gpxexporttypelist = array();
		$gpxexporttypelist[$this->Lang('gpxexporttype_rte')] = 'rte';
		$gpxexporttypelist[$this->Lang('gpxexporttype_trk')] = 'trk';
		$gpxexporttypelist[$this->Lang('gpxexporttype_wpt')] = 'wpt';
		
		return $gpxexporttypelist;
	}

	/* --------------------------------------------------------
		get_humandistance_uom()
		A function to return user friendly unit of measure description of distance
		--------------------------------------------------------*/	
	function get_humandistance_uom($humandistanceuom = 'K')
	{
		switch ($humandistanceuom) {
		case 'C':
			return $this->Lang('uom_centimeter');
		case 'F':
			return $this->Lang('uom_feet');
		case 'I':
			return $this->Lang('uom_inch');
		case 'K':
			return $this->Lang('uom_kilometer');
		case 'M':
			return $this->Lang('uom_mile');
		case 'N':
			return $this->Lang('uom_nauticalmile');
		case 'T':
			return $this->Lang('uom_meter');
		}
	}

	/*---------------------------------------------------------
	  General point to insert new polyline
	  Arguments:
	  $map_id - The map that this polyline will be shown on
	  $name - The name/description of the polyline
	  $strokecolor - The color of the line in hex with #
	  $strokeopacity - The opacity of the line on the map
	  $strokeweight - The thikness of the polyline on the map
	  $distance - The total distance of the polyline
	  $distanceuom - Distance unit of measure
	  ---------------------------------------------------------*/
	function insert_polyline($map_id, $name, $strokecolor = '#000000',
			$strokeopacity = 1, $strokeweight = 2, $distance = 0, 
			$distanceuom = -1) {
		if ($map_id == 0 || $map_id == NULL) return false;
		if ($name == '' || $name == NULL) return false;
		$db = cmsms()->GetDb();
		if ($distanceuom == -1) {
			$distanceuom = $this->getPreference('distanceuom', 'K');
		}
		
		$polyline_id = $db->GenID(cms_db_prefix().'module_googlemaps_polylines_seq');
		$query = 'INSERT INTO '.cms_db_prefix().'module_googlemaps_polylines
			(polyline_id, map_id, name, strokecolor, strokeopacity, strokeweight, 
			distance, distanceuom)
			VALUES (?,?,?,?,?,?,?,?)';
		$db->Execute($query, array($polyline_id, $map_id, $name, strtoupper($strokecolor), 
			$strokeopacity, $strokeweight, $distance, 
			$distanceuom));
		
		return $polyline_id;
	}

	/*---------------------------------------------------------
	  General point to insert new parts of a polyline
	  Arguments:
	  $polyline_id - The line that this part will be added to
	  $seq - The sequence number (so were in the line does this point fit
	  $description - Description of the part
	  $lat - latitude of the point on the map
	  $lon - longitude of the point on the map
	  ---------------------------------------------------------*/
	function insert_polyline_part($polyline_id, $seq, $description = '',
			$lat, $lon) {
		if ($polyline_id == 0 || $polyline_id == NULL) return false;
		if (floatval($lat) == '' || floatval($lat) == 0) return false;
		if (floatval($lon) == '' || floatval($lon) == 0) return false;
		$db = cmsms()->GetDb();
		
		$polylinepart_id = $db->GenID(cms_db_prefix().'module_googlemaps_polylineparts_seq');
		$query = 'INSERT INTO '.cms_db_prefix().'module_googlemaps_polylineparts
			(polylinepart_id, polyline_id, seq, description, lat, lon)
			VALUES (?,?,?,?,?,?)';
		$db->Execute($query, array($polylinepart_id, $polyline_id, $seq, $description, 
			floatval($lat), floatval($lon)));
		
		return true;
	}

	/*---------------------------------------------------------
	 * xml2array() will convert the given XML text to an array in the XML structure. 
	 * Link: http://www.bin-co.com/php/scripts/xml2array/ 
	 * Arguments : 
	 * 	$contents - The XML text 
	 *  $get_attributes - 1 or 0. If this is 1 the function will get the attributes as well as the tag values - this results in a different array structure in the return value.
	 *  $priority - Can be 'tag' or 'attribute'. This will change the way the resulting array sturcture. For 'tag', the tags are given more importance.
	 * Return: The parsed XML in an array form. Use print_r() to see the resulting array structure.
	 * Examples: 
	 *	$array =  xml2array(file_get_contents('feed.xml')); 
	 *  $array =  xml2array(file_get_contents('feed.xml', 1, 'attribute')); 
	  ---------------------------------------------------------*/
	function xml2array($contents, $get_attributes=1, $priority = 'tag') { 
		if(!$contents) return array(); 
	
		if(!function_exists('xml_parser_create')) { 
			//print "'xml_parser_create()' function not found!"; 
			return array(); 
		} 
	
		// Get the XML parser of PHP - PHP must have this module for the parser to work 
		$parser = xml_parser_create(''); 
		xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8"); # http://minutillo.com/steve/weblog/2004/6/17/php-xml-and-character-encodings-a-tale-of-sadness-rage-and-data-loss 
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0); 
		xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1); 
		xml_parse_into_struct($parser, trim($contents), $xml_values); 
		xml_parser_free($parser); 
	
		if(!$xml_values) return;//Hmm... 
	
		// Initializations 
		$xml_array = array(); 
		$parents = array(); 
		$opened_tags = array(); 
		$arr = array(); 
	
		$current = &$xml_array; //Reference 
	
		// Go through the tags. 
		$repeated_tag_index = array(); //Multiple tags with same name will be turned into an array
		foreach($xml_values as $data) { 
			unset($attributes,$value); //Remove existing values, or there will be trouble 
	
			// This command will extract these variables into the foreach scope 
			// tag(string), type(string), level(int), attributes(array). 
			extract($data); //We could use the array by itself, but this cooler. 
	
			$result = array(); 
			$attributes_data = array(); 
			 
			if(isset($value)) { 
				if($priority == 'tag') $result = $value; 
				else $result['value'] = $value; //Put the value in a assoc array if we are in the 'Attribute' mode
			} 
	
			// Set the attributes too. 
			if(isset($attributes) and $get_attributes) { 
				foreach($attributes as $attr => $val) { 
					if($priority == 'tag') $attributes_data[$attr] = $val; 
					else $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr' 
				} 
			} 
	
			// See tag status and do the needed. 
			if($type == "open") { //The starting of the tag '<tag>' 
				$parent[$level-1] = &$current; 
				if(!is_array($current) or (!in_array($tag, array_keys($current)))) { //Insert New tag
					$current[$tag] = $result; 
					if($attributes_data) $current[$tag. '_attr'] = $attributes_data; 
					$repeated_tag_index[$tag.'_'.$level] = 1; 
	
					$current = &$current[$tag]; 
	
				} else { //There was another element with the same tag name 
	
					if(isset($current[$tag][0])) { //If there is a 0th element it is already an array 
						$current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result; 
						$repeated_tag_index[$tag.'_'.$level]++; 
					} else { //This section will make the value an array if multiple tags with the same name appear together
						$current[$tag] = array($current[$tag],$result);//This will combine the existing item and the new item together to make an array
						$repeated_tag_index[$tag.'_'.$level] = 2; 
						 
						if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
							$current[$tag]['0_attr'] = $current[$tag.'_attr']; 
							unset($current[$tag.'_attr']); 
						} 
	
					} 
					$last_item_index = $repeated_tag_index[$tag.'_'.$level]-1; 
					$current = &$current[$tag][$last_item_index]; 
				} 
	
			} elseif($type == "complete") { //Tags that ends in 1 line '<tag />' 
				// See if the key is already taken. 
				if(!isset($current[$tag])) { //New Key 
					$current[$tag] = $result; 
					$repeated_tag_index[$tag.'_'.$level] = 1; 
					if($priority == 'tag' and $attributes_data) $current[$tag. '_attr'] = $attributes_data;
	
				} else { //If taken, put all things inside a list(array) 
					if(isset($current[$tag][0]) and is_array($current[$tag])) {//If it is already an array... 
	
						// ...push the new element into that array. 
						$current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result; 
						 
						if($priority == 'tag' and $get_attributes and $attributes_data) { 
							$current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data; 
						} 
						$repeated_tag_index[$tag.'_'.$level]++; 
	
					} else { //If it is not an array... 
						$current[$tag] = array($current[$tag],$result); //...Make it an array using using the existing value and the new value
						$repeated_tag_index[$tag.'_'.$level] = 1; 
						if($priority == 'tag' and $get_attributes) { 
							if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
								 
								$current[$tag]['0_attr'] = $current[$tag.'_attr']; 
								unset($current[$tag.'_attr']); 
							} 
							 
							if($attributes_data) { 
								$current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data; 
							} 
						} 
						$repeated_tag_index[$tag.'_'.$level]++; //0 and 1 index is already taken
					} 
				} 
	
			} elseif($type == 'close') { //End of tag '</tag>' 
				$current = &$parent[$level-1]; 
			} 
		} 
		 
		return($xml_array); 
	}
}

?>