<?php
$lang['friendlyname'] = 'GoogleMaps';
$lang['moddescription'] = 'Prepare multiple Google maps, multiple coordinates with custom markers. 
Includes EasyLocator to quickly set coordinates. Paths (aka polylines) are also possible.';
$lang['postinstall'] = 'Using GoogleMaps requires "Use GoogleMaps" rights';
$lang['postuninstall'] = 'A pitty to notice you removed module GoogleMaps. Hope you will try and use it later.<br />
<strong>Directory uploads/GoogleMaps is not removed!</strong>';
$lang['really_uninstall'] = 'Really uninstall, all data will be lost';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['prefsupdated'] = 'Module preferences updated.';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['error'] = 'Error!';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['edit'] = 'Edit';
$lang['delete'] = 'Delete';
$lang['areyousure'] = 'Are you sure?';

$lang['addlocation'] = 'Add location';
$lang['addmap'] = 'Add map';
$lang['addmarker'] = 'Add marker';
$lang['addpolyline'] = 'Add polyline';
$lang['address'] = 'Address';
$lang['belongstomap'] = 'Belongs to map';
$lang['controlsizelarge'] = 'Large';
$lang['controlsizesmall'] = 'Small';
$lang['defaultmaptype'] = 'Default map type';
$lang['e_badaddress'] = 'The address specified was invalid or could not be found';
$lang['easylocator_auto'] = 'Auto';
$lang['easylocator_crosshair'] = 'Crosshair';
$lang['easylocator_default'] = 'Default';
$lang['easylocator_hand'] = 'Hand';
$lang['easylocator_help'] = 'Help';
$lang['easylocator_move'] = 'Move';
$lang['easylocator_no'] = 'None';
$lang['easylocator_pointer'] = 'Pointer';
$lang['easylocator_progress'] = 'Progress';
$lang['easylocator_text'] = 'Text';
$lang['easylocator_wait'] = 'Wait';
$lang['easylocatorlat'] = 'Latitude of center map';
$lang['easylocatorlevel'] = 'Easy Locator zoom level';
$lang['easylocatorlon'] = 'Longitude of center map';
$lang['easylocatorsavelast'] = 'Save last used values';
$lang['easylocatorsettings'] = 'Easy Locator settings, to be used when adding map/marker';
$lang['easylocatortemplate'] = 'Template for map to show';
$lang['exporttogpx'] = 'Export to GPX waypoints';
$lang['gpxexporttype_rte'] = 'Routes';
$lang['gpxexporttype_trk'] = 'Tracks';
$lang['gpxexporttype_wpt'] = 'Waypoints';
$lang['importfilenotfound'] = 'File %s to import could not be found';
$lang['importnewname'] = ' Just imported';
$lang['importlocalpolyline'] = 'Import polyline';
$lang['importpolylinesucceeded'] = 'The import of the polyline ended succesfully';
$lang['info_triggerclick'] = 'On click';
$lang['info_triggermouseover'] = 'On mouse over';
$lang['invalidopacity'] = 'Invalid opacity (must be between 0 and 1)';
$lang['is'] = 'is';
$lang['latitude'] = 'Latitude';
$lang['longitude'] = 'Longitude';
$lang['lookupservice'] = 'Which lookup service to use';
$lang['map_id'] = 'Map ID';
$lang['mapadded'] = 'Map has been added';
$lang['mapdeleted'] = 'Map (and all its markers) has been deleted';
$lang['maps'] = 'Maps';
$lang['maptypehybrid'] = 'Hybrid';
$lang['maptypemap'] = 'Roadmap';
$lang['maptypesatellite'] = 'Satellite';
$lang['maptypeterrain'] = 'Terrain';
$lang['mapupdated'] = 'Map has been updated';
$lang['marker'] = 'Marker';
$lang['markeradded'] = 'Marker has been saved';
$lang['markerdeleted'] = 'Marker has been deleted';
$lang['markererror'] = 'No markers found in directory \'uploads/GoogleMaps/markers\'';
$lang['markericon'] = 'Marker icon';
$lang['markers'] = 'Markers';
$lang['markerupdated'] = 'Marker has been updated';
$lang['noiconselected'] = 'No icon selected as marker';
$lang['nokey'] = 'GoogleMaps API key missing in configuration';
$lang['nomap'] = 'No map provided';
$lang['nonamegiven'] = 'No name given, while this is mandatory';
$lang['patherror'] = 'Path to marker directory \'uploads/GoogleMaps/markers\' doesn\'t exist';
$lang['polylineadded'] = 'Polyline has been added';
$lang['polylinedeleted'] = 'Polyline has been deleted';
$lang['polylinepartdeleted'] = 'Polyline part has been deleted';
$lang['polylines'] = 'Polylines';
$lang['polylineupdated'] = 'Polyline has been updated';
$lang['query_address'] = 'Address lookup';
$lang['returntolist'] = 'Return to list';
$lang['settings'] = 'Settings';
$lang['settings_saved'] = 'Settings saved';
$lang['Submit'] = 'Submit';
$lang['title_address'] = 'Search location for address';
$lang['title_addressquery'] = 'Address queries';
$lang['title_admin_panel'] = 'GoogleMaps Module';
$lang['title_bounds_fudge'] = 'Fudge factor on edges';
$lang['title_center_lat'] = 'Default center latitude';
$lang['title_center_lon'] = 'Default center longitude';
$lang['title_color'] = 'Color';
$lang['title_controls'] = 'Enable controls';
$lang['title_controls_size'] = 'Controls size';
$lang['title_crudeness'] = 'Crudeness';
$lang['title_del'] = 'Del';
$lang['title_directions'] = 'Show directions';
$lang['title_distance'] = 'Distance';
$lang['title_distanceuom'] = 'Distance unit of measure';
$lang['title_distanceuomdefault'] = 'Default distance unit of measure';
$lang['title_description'] = 'Description';
$lang['title_easylocator'] = 'Easy locator';
$lang['title_easylocatorcursor'] = 'Cursor on back end maps';
$lang['title_example'] = 'Example';
$lang['title_gpxexporttype'] = 'GPX export type';
$lang['title_height'] = 'Height of map';
$lang['title_importfile'] = 'File to import';
$lang['title_importhelp'] = 'Select map that the polyline will belong to. <br />
The crudeness factor that is entered will generate every n-th way point/track point/route point a sequence. Thus entering a 
10 here means only the 10th, 20th, 30th etc read point will result in a point on the polyline. Defaults to 1.<br />
Select a local stored file.<br />
Press submit to create the polyline.<br />
<strong>Notes:</strong><br />
  - Only latitude/longitude and description are imported;<br />
  - File to import should follow GPX standard;<br />
  - Way points, track points and route points are used to prepare a polyline;<br />
  - If an imported file contains more than one type (ie. way points and route information), multiple 
polylines are prepared.<br />
<br />';
$lang['title_info'] = 'Marker info (html allowed)';
$lang['title_info_trigger'] = 'Info window trigger';
$lang['title_info_window'] = 'Enable marker info windows';
$lang['title_locationprecision'] = 'Location precision (number of decimals):';
$lang['title_locations'] = 'Locations';
$lang['title_maptype'] = 'Map type';
$lang['title_mod_admin'] = 'Module Admin Panel';
$lang['title_mod_prefs'] = 'Module Preferences';
$lang['title_name'] = 'Name';
$lang['title_opacity'] = 'Opacity';
$lang['title_scale_control'] = 'Show scale';
$lang['title_searchrequest'] = 'Location for';
$lang['title_seq'] = 'Seq';
$lang['title_seqincrement'] = 'Sequence for polyline increments with:';
$lang['title_sidebar'] = 'Sidebar for markers';
$lang['title_type'] = 'Type';
$lang['title_type_controls'] = 'Display type controls enabled';
$lang['title_weight'] = 'Line weight (in pixels)';
$lang['title_width'] = 'Width of map on front end';
$lang['title_zoom'] = 'Zoom level';
$lang['title_zoom_encompass'] = 'Try to fit all markers';
$lang['title_zoomscrollwheel'] = 'Allow wheel scroll zooming';
$lang['uom_centimeter'] = 'cm';
$lang['uom_feet'] = 'Feet';
$lang['uom_inch'] = 'Inch';
$lang['uom_kilometer'] = 'Km';
$lang['uom_meter'] = 'Mtr';
$lang['uom_mile'] = 'Mile';
$lang['uom_nauticalmile'] = 'NMi';
$lang['usecache'] = 'Use caching for geocodes (not working yet)';
$lang['usemarkershadows'] = 'Use marker shadows?';
$lang['yahooappid'] = 'Application ID for yahoo'; 
$lang['yourmaps'] = 'Your Maps';
$lang['yourmarkers'] = 'Your Markers';

$lang['help'] = '
<h3>What Does This Do?</h3>
<p>This module is intented for integrating GoogleMaps as a part of your site.</p>
<h3>How Do I Use It</h3>
<p>First you must update the settings for this module, to have defaults set for new maps.</p>
<p>Then you can call this module in your template with {cms_module module=\'GoogleMaps\' map=\'test\'} </p>
<h3>Markers</h3>
<p>User defined markers can be loaded into uploads/GoogleMaps/markers. The connected shadow images should be loaded in 
	uploads/GoogleMaps/markershadows.<br>
	Naming convention is [markericon]s.png (ie. marker is bigblue.png, markershadow is bigblues.png).<br>
	If a shadow is not found, the default version will be used (which may not be the correct shadow of the marker at all).<br>
	In the settings use the preference \'Use marker shadows\' to show/hide them. Showing the shadows slows down the buildup of the
	map, due to more internal checks.<br>
	Only images with extension .png are currently supported.</p>
<p>Markers have the option to include text. This text may contain html coding. In this way you can show
images, control the color of various parts.<br />
Marker information may contain one or more global content blocks. Even content blocks that contain 
tags (ie. to modules) may be used. 
</p>
<h3>Lines</h3>
<p>Polylines allows you to draw lines from a certain coordinate on a map to the next. Multiple lines are possible 
per map. This allows you to prepare visual one line that is a combination of multiple colored 
separate polyline setups.</p>
<p>From the polylines tab, you are able to import gpx files. One of the test files used is: <a href="http://www.topografix.com/fells_loop.gpx" target="_blank">fells_loop.gpx near Boston MA</a><br />
Testing has been performed with a 1.8 Mb file with more than 15.000 track points.<br />
Importing this amount slows down the rendering of the page in the back end and the front end. During the import of 
a file you could use the \'Crudeness\' factor which will take every nth point to import. Thus 15.000 points 
imported with a crudeness factor of 100 will generate 150 coordinations for the imported GPX file.
</p>
<h3>Parameters</h3>
<p>This module is even more flexible through the usage of the parameters (see the parameter list). Each parameter as available during the preparation of a map, can be 
	overriden for the front end. So you are able to prepare one map and display it in various ways by using one or more parameters.</p>
<h3>Settings</h3>
<p>In the settings tab it is possible to prepare a number of default settings for what is called the <strong>\'Easy Locator\'</strong>. When adding a new map,
a map is shown based upon these default settings.<br />
When editing a map or a marker, the shown map is always centered at the coordinates shown just below the map.<br />
When you edit a map, the map settings (center coordinates and zoom level) are used to prepare the Easy Locator.<br />
Turning on the setting \'Save last used values\', will save the coordinates, zoom level when used on a map. The next time you add
a map, the last saved coordinates are used to show the Easy Locator.<br />
Note: This saving is only done on editing a map or marker (zoom level not saved when editing a marker). <br />
The GPX export type is used when exporting a polyline to a gpx file. Depending on your device 
you will use one of the available types. You will have to experiment with this setting in 
conjunction with the export of a polyline.</p>
<h3>Translations</h3>
Translations of this module can be found via the <a href="http://svn.cmsmadesimple.org/svn/translatecenter/modules/GoogleMaps/" target="_blank">translation center in the forge</a>.
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:<br>
<ul>
	<li>The CMS Made Simple forum;</li>
</ul>
</p>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Security</h3>
<p>User must have "Use GoogleMaps" permissions set to edit maps</p>
';

// param help
$lang['help_param_bounds_fudge'] = 'This will adjust how much map boundary encompasses the map markers.';
$lang['help_param_centerlat'] = 'The latitude to which the map should be centered.';
$lang['help_param_centerlon'] = 'The longitude to which the map should be centered.';
$lang['help_param_controls'] = 'If set to 0 (zero), there will be no controls to zoom/move around the map.';
$lang['help_param_controls_size'] = 'This sets the map control size. Relevant only if map controls are
enabled. large = map zoom/move with slider. small = zoom/move without slider. Large is default.';
$lang['help_param_directions'] = 'This enables map directions in the bottom of the pop-up info window. Default is disabled.
\'1\' Will enable the directions.';
$lang['help_param_height'] = 'Sets the height of the map window. This can be either px or %.';
$lang['help_param_info_trigger'] = 'This sets the info window trigger behavior. click = info window comes up
        when clicking on a marker. mouseover = info window comes up when mousing over a marker.';
$lang['help_param_info_window'] = 'Enables info windows on map markers.';
$lang['help_param_language'] = 'See: <a href="http://spreadsheets.google.com/pub?key=p9pdwsai2hDMsLkXsoM05KQ&gid=1" target="_blank">
the list of languages</a>';
$lang['help_param_map'] = 'Set which map to show';
$lang['help_param_pan'] = 'Use \'1\' or true to show panning control on map (default off)';
$lang['help_param_scale'] = 'Use \'1\' or true to show scale.';
$lang['help_param_sidebar'] = 'Use \'1\' to enable the map sidebar.';
$lang['help_param_streetview'] = 'Use \'1\' or true to show the streetview pegman (default off)';
$lang['help_param_type'] = 'This sets the default map type. Relevant only if map type controls are enabled. 
	map = default map. satellite = satellite view. hybrid = hybrid view. terrain = physical view with roads';
$lang['help_param_type_controls'] = 'Use \'1\' enable the map type controls (map/satellite/hybrid/terrain)';
$lang['help_param_width'] = 'Sets the width of the map window. This can be either px or %.';
$lang['help_param_zoom'] = 'This sets the map zoom level.';
$lang['help_param_zoom_encompass'] = 'Use \'1\' to enable the zoom encompass so map zoom is as small as possible
        and include all map markers.';

//table fields
$lang['t_name'] = 'Name';
$lang['t_belongs_to'] = 'Belongs to map';
$lang['t_description'] = 'Description';
$lang['center_lat'] = 'Default center latitude';
$lang['center_lon'] = 'Default center longitude';
$lang['t_type'] = 'Display type';
$lang['t_width'] = 'Width';
$lang['t_height'] = 'Height';
$lang['t_controls'] = 'Enable controls';
$lang['t_controls_size'] = 'Controls size';
$lang['t_sidebar'] = 'Sidebar for markers';
$lang['t_type_controls'] = 'Display type controls enabled';
$lang['t_directions'] = 'Show directions';
$lang['t_zoom'] = 'Zoom level';
$lang['t_zoom_encompass'] = 'Try to fit all markers';
$lang['t_zoomscrollwheel'] = 'Allow wheel scroll zooming';
$lang['t_scale_control'] = 'Show scale';
$lang['t_bounds_fudge'] = 'Bounds_fudge';
$lang['t_info_window'] = 'Enable marker info windows';
$lang['t_info_trigger'] = 'Info window trigger';

$lang['t_info'] = 'Marker info (html allowed)';
$lang['t_lan'] = 'Latitude';
$lang['t_lon'] = 'Longitude';
$lang['t_icon'] = 'Marker icon';
$lang['t_address'] = 'Marker address';
?>
