<?php
	
# Prepare list of markers...
$entryarray = array();

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}
$config = $gCms->GetConfig();
// Read the directory that contain the images of the markers
$path = '..'.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.$this->getName().DIRECTORY_SEPARATOR.'markers';

$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_markers ORDER BY name';
$dbresult = $db->Execute($query);

$rowclass = 'row1';

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['marker_id'];
	$mapinfo = array();
	$mapinfo = $this->GetMapInformation($row['map']);
	$onerow->map = $this->CreateLink($id, 'editmap', $returnid, $mapinfo['name'], array('map_id'=>$row['map']));
	//$onerow->map = $this->CreateLink($id, 'editmap', $returnid, $mapinfo['name'], array('map_id'=>$row['map_id']));
	$onerow->address = $row['address'];
	$onerow->lat = $row['lat']; 
	$onerow->lon = $row['lon'];
	if ($row['icon'] != '') {
		$onerow->icon = '<img src="'.$path.DIRECTORY_SEPARATOR.$row['icon'].'" alt="'.$row['icon'].'" height="18"> ('.$row['icon'].')';
	}
	$onerow->name = $this->CreateLink($id, 'editmarker', $returnid, $row['name'], array('marker_id'=>$row['marker_id']));

	$onerow->editlink = $this->CreateLink($id, 'editmarker', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('marker_id'=>$row['marker_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Markers','marker_id'=>$row['marker_id']), $this->Lang('areyousure'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign_by_ref('items', $entryarray);
$this->smarty->assign('itemcount', count($entryarray));
// Retrieve the number of Global Content Blocks from user preferences (sorry this is a bit tricky)
$listgcbs_pagelimit = get_preference( $user_id, 'listgcbs_pagelimit' );
if ($listgcbs_pagelimit == 0 || $listgcbs_pagelimit == NULL) $listgcbs_pagelimit = 20;
$this->smarty->assign('pagelimit', $listgcbs_pagelimit);
#Setup links
$this->smarty->assign('addlink', $this->CreateLink($id, 'addmarker', $returnid, $this->Lang('addmarker'), array(), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('addlink', $this->CreateLink($id, 'addmarker', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newfolder.gif', $this->Lang('addmarker'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmarker', $returnid, $this->Lang('addmarker'), array(), '', false, false, 'class="pageoptions"'));

$this->smarty->assign('title_name', $this->Lang('title_name'));
$this->smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$this->smarty->assign('title_address', $this->Lang('address'));
$this->smarty->assign('title_latitude', $this->Lang('latitude'));
$this->smarty->assign('title_longitude', $this->Lang('longitude'));
$this->smarty->assign('title_icon', $this->Lang('markericon'));

#Display template
echo $this->ProcessTemplate('listmarkers.tpl');

?>