<?php
	
# Prepare list of maps...
$entryarray = array();

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_maps ORDER BY name';
$dbresult = $db->Execute($query);

$rowclass = 'row1';

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['map_id'];
	$onerow->name = $this->CreateLink($id, 'editmap', $returnid, $row['name'], array('map_id'=>$row['map_id']));
	$onerow->center_lat = $row['center_lat']; 
	$onerow->center_lon = $row['center_lon'];
	$onerow->type = $this->Lang('maptype'.$row['type']);

	$onerow->editlink = $this->CreateLink($id, 'editmap', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('map_id'=>$row['map_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Maps','map_id'=>$row['map_id']), $this->Lang('areyousure'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign_by_ref('items', $entryarray);
$this->smarty->assign('itemcount', count($entryarray));
// Retrieve the number of Global Content Blocks from user preferences (sorry this is a bit tricky)
$listgcbs_pagelimit = get_preference( $user_id, 'listgcbs_pagelimit' );
if ($listgcbs_pagelimit == 0 || $listgcbs_pagelimit == NULL) $listgcbs_pagelimit = 20;
$this->smarty->assign('pagelimit', $listgcbs_pagelimit);
#Setup links
$this->smarty->assign('addlink', $this->CreateLink($id, 'addmap', $returnid, $this->Lang('addmap'), array(), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('addlink', $this->CreateLink($id, 'addmap', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newfolder.gif', $this->Lang('addmap'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmap', $returnid, $this->Lang('addmap'), array(), '', false, false, 'class="pageoptions"'));

$this->smarty->assign('title_name', $this->Lang('title_name'));
$this->smarty->assign('title_centerlatitude', $this->Lang('title_center_lat'));
$this->smarty->assign('title_centerlongitude', $this->Lang('title_center_lon'));
$this->smarty->assign('title_maptype', $this->Lang('title_maptype'));

#Display template
echo $this->ProcessTemplate('listmaps.tpl');

?>