<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2012 by Duketown 
#
# Allow user to find coordinates using address lookup
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Use GoogleMaps'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

$address = '';
if (isset($params['address'])) {
	$address = $params['address'];
}

$requestfound = false;
$addmarker = '';
if (isset($params['lat']) && isset($params['lon'])) {
	$requestfound = true;
	
	$lat = $params['lat'];
	$lon = $params['lon'];
	$addmarker = $this->CreateLink($id, 'addmarker', $returnid, $this->Lang('addmarker'), 
		array('address'=>$address,'lat'=>$lat,'lon'=>$lon,'name'=>$address));
}

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addresslookup', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_addressquery', $this->Lang('title_addressquery'));
$smarty->assign('title_address', $this->Lang('title_address'));
$smarty->assign('input_address', $this->CreateInputText($id, 'address', $address, 100, 1024));
$smarty->assign('requestfound', $requestfound);
$smarty->assign('title_searchrequest', $this->Lang('title_searchrequest'));
$smarty->assign('title_latitude', $this->Lang('latitude'));
$smarty->assign('latitude', $lat);
$smarty->assign('title_longitude', $this->Lang('longitude'));
$smarty->assign('longitude', $lon);
$smarty->assign('geoerror', $params['geoerror']);
$smarty->assign('badaddress', $this->Lang('e_badaddress'));
$smarty->assign('addmarker', $addmarker);

$smarty->assign('hidden', $this->CreateInputHidden($id, 'module', 'googlemaps'));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('Submit')));

#Display template
echo $this->ProcessTemplate('addresslookup.tpl');

?>