<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2010 by Duketown 
#
# This function supports adding a marker
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Use GoogleMaps')) {
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}
if( !isset($params['polyline_id']) ) return;

$polyline_id = $params['polyline_id'];
$name = $params['name'];

$filename = $name.'.gpx';
$smarty->assign('polyline_name', $name);
$smarty->assign('created', date("Y-m-d"));
$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylineparts 
	WHERE polyline_id = ?
	ORDER BY seq';
$dbresult = $db->Execute($query, array($polyline_id));

$waypoints = array();
while ($dbresult && $row = $dbresult->FetchRow()) {
	$onerow = new stdClass();

	$onerow->lat = '"'.$row['lat'].'"';
	$onerow->lon = '"'.$row['lon'].'"';
	if ($row['description'] != '') {
		$onerow->description = '<![CDATA['.$row['description'];
	}
	else {
		$onerow->description = '';
	}
	
	$waypoints[] = $onerow;
}
$smarty->assign_by_ref('waypoints',$waypoints);
// Initialize the way the output is set as waypoint, route or track
$smarty->assign('gpxexporttype', $this->GetPreference('gpxexporttype', 'trk')); 

if(ini_get('zlib.output_compression'))
  {
    ini_set('zlib.output_compression', 'Off');
  }

if(!ini_get_boolean('safe_mode'))
  {
    set_time_limit(0);
  }

// get the data
$handlers = ob_list_handlers(); 
for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }
$data = $this->ProcessTemplate('polyline_gpx.tpl');

header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private',false);
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header("Content-Disposition: attachment; filename=\"$filename\"" );
header('Content-Transfer-Encoding: binary');
header('Content-Length: ' . strlen($data));
echo $data;

@flush(); @ob_flush(); @ob_flush();
// EOF
?>