<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown 
#
# This function supports importing a file with points that form a line
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Use GoogleMaps')) {
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

if (isset($params['cancel'])) {
 	 $params = array('active_tab' => 'polylines');
	 $this->Redirect($id, 'defaultadmin', $returnid, $params);
}

// Prepare settings for the polyline
if (isset($params['map'])) { $map_id = $params['map']; }
$strokecolor = '#000000';
if (isset($params['strokecolor'])) {
	$strokecolor = $params['strokecolor'];
}
$strokeopacity = '1.0';
if (isset($params['strokeopacity'])) {
	$strokeopacity = $params['strokeopacity'];
}
$strokeweight = '2';
if (isset($params['strokeweight'])) {
	$strokeweight = $params['strokeweight'];
}
$name = $this->Lang('importnewname');
if (isset($params['name'])) {
	$name = $params['name'];
}
// To obtain a more crude line, it helps to skip generating a part
// every now and then. This is done by the filter. The lower the 
// number the finer the line prepared
$crudeness = 1;
if (isset($params['crudeness'])) $crudeness = $params['crudeness'];
if (intval($crudeness) <= 0) $crudeness = 1;

$errdesc = '';
// Does the file exist
if (!isset($_FILES[$id.'polylinefile'])) {
	$errdesc = $this->Lang('importfilenotfound', $_FILES[$id.'polylinefile']);
	$params = array('tab_error'=> $errdesc, 'active_tab' => 'polylines');
}
else {
	$filename = $_FILES[$id.'polylinefile']['tmp_name'];
	$handle = fopen($filename, "r");
	if ($handle === false)
	{
		echo '<p>'.$this->Lang('error_cantopenfile').'</p>';
	}
	$plarray = array();
	$plarray =  googlemaps_utils::xml2array(fread($handle, filesize($filename)), 1, 'attribute');
	fclose($handle);
		
	// Information is now available in array. Let's process it depending on type used.

	// Read thru the points of the line and create polyline parts of them
	if (count($plarray['gpx']['wpt']) > 0) {
		if ($plarray['gpx']['name']['value'] != '') {
			$name = $plarray['gpx']['name']['value'];
		}
		$polyline_id = googlemaps_utils::insert_polyline($map_id, $name); 
		$cc = 1;
		// A list of waypoints are used
		$countparts = count($plarray['gpx']['wpt']);
		$seqincrement = $this->GetPreference('seqincrement', 10);
		$seq = $seqincrement;
		for ($i = 0; $i < $countparts; $i++) {
			if (($cc % $crudeness) == 0) {
				$lat = $plarray['gpx']['wpt'][$i]['attr']['lat'];
				$lon = $plarray['gpx']['wpt'][$i]['attr']['lon'];
				$description = $plarray['gpx']['wpt'][$i]['desc']['value'];
				// Add the polypart
				$ppadded = googlemaps_utils::insert_polyline_part($polyline_id, $seq, 
					$description, $lat, $lon);
				if ($ppadded) {
					$seq += $seqincrement;
				}
			}
			$cc++;
		}
	}
	
	if (count($plarray['gpx']['trk']) > 0) {
		$polyline_id = googlemaps_utils::insert_polyline($map_id, $name); 
		// A list of tracks is supplied
		$countparts = count($plarray['gpx']['trk']['trkseg']['trkpt']);
		// If multiple tracking segments, the previous count is zero
		if ($countparts == 0) {
			$countseg = count($plarray['gpx']['trk']['trkseg']);
		}
		if ($plarray['gpx']['trk']['name']['value'] != '') {
			$query = 'UPDATE '.cms_db_prefix().'module_googlemaps_polylines SET
				name = ?
				WHERE polyline_id = ?';
			$db->Execute($query, array($plarray['gpx']['trk']['name']['value'], $polyline_id));
		}
		$seqincrement = $this->GetPreference('seqincrement', 10);
		$seq = $seqincrement;
		$description = '';
		$cc = 1;
		if ($countparts > 0) {
			for ($i = 0; $i < $countparts; $i++) {
				if (($cc % $crudeness) == 0) {
					$lat = $plarray['gpx']['trk']['trkseg']['trkpt'][$i]['attr']['lat'];
					$lon = $plarray['gpx']['trk']['trkseg']['trkpt'][$i]['attr']['lon'];
					// Add the polypart
					$ppadded = googlemaps_utils::insert_polyline_part($polyline_id, $seq, 
						$description, $lat, $lon);
					if ($ppadded) {
						$seq += $seqincrement;
					}
				}
				$cc++;
			}
		}
		else {
			// Multiple segments, so build parts per segment
			for ($s = 0; $s < $countseg; $s++) {
				$countparts = count($plarray['gpx']['trk']['trkseg'][$s]['trkpt']);
				for ($i = 0; $i < $countparts; $i++) {
					if (($cc % $crudeness) == 0) {
						$lat = $plarray['gpx']['trk']['trkseg'][$s]['trkpt'][$i]['attr']['lat'];
						$lon = $plarray['gpx']['trk']['trkseg'][$s]['trkpt'][$i]['attr']['lon'];
						// Add the polypart
						$ppadded = googlemaps_utils::insert_polyline_part($polyline_id, $seq, 
							$description, $lat, $lon);
						if ($ppadded) {
							$seq += $seqincrement;
						}
					}
					$cc++;
				}
			}
		}
	}
	if (count($plarray['gpx']['rte']) > 0) {
		$polyline_id = googlemaps_utils::insert_polyline($map_id, $name); 
		$cc = 1;
		// A list of routes is supplied
		if ($plarray['gpx']['rte']['desc']['value'] != '') {
			$query = 'UPDATE '.cms_db_prefix().'module_googlemaps_polylines SET
				name = ?
				WHERE polyline_id = ?';
			$db->Execute($query, array($plarray['gpx']['rte']['desc']['value'], $polyline_id));
		}

		$countparts = count($plarray['gpx']['rte']['rtept']);
		$seqincrement = $this->GetPreference('seqincrement', 10);
		$seq = $seqincrement;
		for ($i = 0; $i < $countparts; $i++) {
			if (($cc % $crudeness) == 0) {
				$lat = $plarray['gpx']['rte']['rtept'][$i]['attr']['lat'];
				$lon = $plarray['gpx']['rte']['rtept'][$i]['attr']['lon'];
				$description = $plarray['gpx']['rte']['rtept'][$i]['desc']['value'];
				// Add the polypart
				$ppadded = googlemaps_utils::insert_polyline_part($polyline_id, $seq, 
					$description, $lat, $lon);
				if ($ppadded) {
					$seq += $seqincrement;
				}
			}
			$cc++;
		}
	}
	if ($errdesc == '') {
		$params = array('tab_message'=> 'importpolylinesucceeded', 'active_tab' => 'polylines');
	}
	else {
		$params = array('tab_error'=> $errdesc, 'active_tab' => 'polylines');
	}

}
$this->Redirect($id, 'defaultadmin', '', $params);

?>