<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown 
#
# This function supports importing a file with points that form a line
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Use GoogleMaps')) {
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

$this->smarty->assign('title_importhelp', $this->Lang('title_importhelp'));

// Prepare a list of maps
$maplist = array();
$maplist = googlemaps_utils::get_list_maps();

// Set default crudeness factor
$crudeness = 1;

$smarty->assign('startform', $this->CreateFormStart($id, 'admin_import_localfile', 
	$returnid, 'post', 'multipart/form-data'));
$smarty->assign('title_importfile', $this->Lang('title_importfile'));
$smarty->assign('input_polylinefile', $this->CreateInputFile($id, 'polylinefile'));
$smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$smarty->assign('input_belongstomap', $this->CreateInputDropdown($id, 'map', $maplist, -1, $usedmap));
$smarty->assign('title_crudeness', $this->Lang('title_crudeness'));
$smarty->assign('input_crudeness', $this->CreateInputText($id, 'crudeness', $crudeness, 5, 5));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
$this->smarty->assign('endform', $this->CreateFormEnd());

echo $this->ProcessTemplate('admin_import_local.tpl');
?>