<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2010 by Duketown 
#
# This function supports adding a map
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

$user_id = 0;
if (get_userid() ) {
	$user_id = get_userid();
}
$owner_id = $user_id;

if (!$this->CheckPermission('Use GoogleMaps'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'maps');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$description = '';
if (isset($params['description'])) {
	$description = $params['description'];
}

$center_lat = '';
if (isset($params['center_lat'])) {
	$center_lat = $params['center_lat'];
}

$center_lon = '';
if (isset($params['center_lon'])) {
	$center_lon = $params['center_lon'];
}

$type = 'map';
if (isset($params['type'])) {
	$type = $params['type'];
}

$width = '';
if (isset($params['width'])) {
	$width = $params['width'];
}

$height = '';
if (isset($params['height'])) {
	$height = $params['height'];
}

$controls = 0;
if (isset($params['controls'])) {
	$controls = $params['controls'];
}

$controls_size = '';
if (isset($params['controls_size'])) {
	$controls_size = $params['controls_size'];
}

$type_controls = 0;
if (isset($params['type_controls'])) {
	$type_controls = $params['type_controls'];
}

$sidebar = 0;
if (isset($params['sidebar'])) {
	$sidebar = $params['sidebar'];
}

$directions = 0;
if (isset($params['directions'])) {
	$directions = $params['directions'];
}

$usedzoom = $this->GetPreference('easylocatorlevel', 10);
if (isset($params['zoom'])) {
	$usedzoom = $params['zoom'];
}

$zoomscrollwheel = 0;

$zoom_encompass = 0;
if (isset($params['zoom_encompass'])) {
	$zoom_encompass = $params['zoom_encompass'];
}

$scale_control = 0;
if (isset($params['scale_control'])) {
	$scale_control = $params['scale_control'];
}

$bounds_fudge = '';
if (isset($params['bounds_fudge'])) {
	$bounds_fudge = $params['bounds_fudge'];
}

$info_window = 0;
if (isset($params['info_window'])) {
	$info_window = $params['info_window'];
}

$info_trigger = '';
if (isset($params['info_trigger'])) {
	$info_trigger = $params['info_trigger'];
}

$name = '';
if (isset($params['name']))
{
	$name = $params['name'];
	if ($name != '') {
		$map_id = $db->GenID(cms_db_prefix().'module_googlemaps_maps_seq');
		$query = 'INSERT INTO '.cms_db_prefix().'module_googlemaps_maps 
			(map_id, name, description, center_lat, center_lon, owner_id, 
			type, width, height, controls, controls_size, type_controls, 
			sidebar, directions, zoom, zoomscrollwheel, zoom_encompass,
			scale_control, bounds_fudge, info_window, info_trigger) 
			VALUES (?,?,?,?,?,?,
				?,?,?,?,?,?,
				?,?,?,?,?,
				?,?,?,?)';
		$dbresult = $db->Execute($query, array($map_id, $name, $description, $center_lat, 
			$center_lon, $owner_id, $type, $width, $height, $controls, $controls_size, 
			$type_controls, $sidebar, $directions, $usedzoom, $zoomscrollwheel,	
			$zoom_encompass, $scale_control, $bounds_fudge, $info_window,
			$info_trigger));
		$this->SaveEasyLocator($center_lat, $center_lon, $usedzoom);

		$params = array('tab_message'=> 'mapadded', 'active_tab' => 'maps');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else {
			echo $this->ShowErrors($this->Lang('nonamegiven'));
	}
}

// Check what user setting is for Global Content Block wysiwyg
$allow_wysiwyg = get_preference( $user_id, 'gcb_wysiwyg' );

// Prepare a list of map types
$typelist = array();
$typelist = $this->GetMapTypes();
switch ($this->GetPreference('defaultmaptype')) {
	case 'hybrid':
		$smarty->assign('maptype', 'HYBRID');
		break;
	case 'satellite':
		$smarty->assign('maptype', 'SATELLITE');
		break;
	case 'terrain':
		$smarty->assign('maptype', 'TERRAIN');
		break;
	default:
		$smarty->assign('maptype', 'ROADMAP');
		break;
}
// Prepare a list of control sizes
$controls_sizelist = array();
$controls_sizelist[$this->Lang('controlsizelarge')] = 'large';
$controls_sizelist[$this->Lang('controlsizesmall')] = 'small';

// Prepare a list of zoom levels
$zoomlist = array();
for ($i = 1; $i < 20; $i++) {
	$zoomlist[$i - 1] = $i;
}

// Prepare a list of window triggers
$info_triggerlist = array();
$info_triggerlist[$this->Lang('info_triggerclick')] = 'click';
$info_triggerlist[$this->Lang('info_triggermouseover')] = 'mouseover';

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addmap', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_name', $this->Lang('title_name'));
$smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 40, 80, 'class="defaultfocus"'));
$smarty->assign('title_description', $this->Lang('title_description'));
$smarty->assign('input_description', $this->CreateTextArea($allow_wysiwyg, $id, $description, 'description', '', '', '', '', '80', '3'));
$smarty->assign('title_center_lat', $this->Lang('title_center_lat'));
$smarty->assign('input_center_lat', $this->CreateInputText($id, 'center_lat', $center_lat, 40, 100));
$smarty->assign('title_center_lon', $this->Lang('title_center_lon'));
$smarty->assign('input_center_lon', $this->CreateInputText($id, 'center_lon', $center_lon, 40, 100));
$smarty->assign('title_type', $this->Lang('title_type'));
$smarty->assign('input_type', $this->CreateInputRadioGroup ($id, 'type', $typelist, $type, '', '&nbsp;'));
$smarty->assign('title_width', $this->Lang('title_width'));
$smarty->assign('input_width', $this->CreateInputText($id, 'width', $width, 40, 50));
$smarty->assign('title_height', $this->Lang('title_height'));
$smarty->assign('input_height', $this->CreateInputText($id, 'height', $height, 40, 50));
$smarty->assign('title_controls',$this->Lang('title_controls'));
$smarty->assign('input_controls', $this->CreateInputCheckbox($id, 'controls', true, $controls));
$smarty->assign('title_controls_size', $this->Lang('title_controls_size'));
$smarty->assign('input_controls_size', $this->CreateInputRadioGroup ($id, 'controls_size', $controls_sizelist, $controls_size, '', '&nbsp;'));
$smarty->assign('title_type_controls',$this->Lang('title_type_controls'));
$smarty->assign('input_type_controls', $this->CreateInputCheckbox($id, 'type_controls', true, $type_controls));
$smarty->assign('title_sidebar',$this->Lang('title_sidebar'));
$smarty->assign('input_sidebar', $this->CreateInputCheckbox($id, 'sidebar', true, $sidebar));
$smarty->assign('title_directions',$this->Lang('title_directions'));
$smarty->assign('input_directions', $this->CreateInputCheckbox($id, 'directions', true, $directions));
$smarty->assign('title_zoom',$this->Lang('title_zoom'));
$smarty->assign('input_zoom', $this->CreateInputDropdown($id, 'zoom', $zoomlist, -1, $usedzoom));
$smarty->assign('title_zoom_encompass',$this->Lang('title_zoom_encompass'));
$smarty->assign('input_zoom_encompass', $this->CreateInputCheckbox($id, 'zoom_encompass', true, $zoom_encompass));
$smarty->assign('title_scale_control',$this->Lang('title_scale_control'));
$smarty->assign('input_scale_control', $this->CreateInputCheckbox($id, 'scale_control', true, $scale_control));
$smarty->assign('title_bounds_fudge', $this->Lang('title_bounds_fudge'));
$smarty->assign('input_bounds_fudge', $this->CreateInputText($id, 'bounds_fudge', $bounds_fudge, 40, 50));
$smarty->assign('title_info_window',$this->Lang('title_info_window'));
$smarty->assign('input_info_window', $this->CreateInputCheckbox($id, 'info_window', true, $info_window));
$smarty->assign('title_info_trigger', $this->Lang('title_info_trigger'));
$smarty->assign('input_info_trigger', $this->CreateInputRadioGroup ($id, 'info_trigger', $info_triggerlist, $info_trigger, '', '&nbsp;'));

// Pass the id, so it can be used in the java script of the easylocator 
$smarty->assign('id',$id);

// Prepare the settings for the easylocator
$smarty->assign('title_easylocator', $this->Lang('title_easylocator'));
$smarty->assign('easylocatorlat', $this->GetPreference('easylocatorlat', 44));
$smarty->assign('easylocatorlon', $this->GetPreference('easylocatorlon', -63));
$smarty->assign('easylocatorlevel', $this->GetPreference('easylocatorlevel'), 1);
$smarty->assign('easylocatorcursor', $this->GetPreference('easylocatorcursor', 'crosshair'));

$smarty->assign('hidden', $this->CreateInputHidden($id, 'map_id', $map_id));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editmap.tpl');
?>