<?php

$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylines ORDER BY name';
$dbresult = $db->Execute($query);

$entryarray = array();
$rowclass = 'row1';

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['polyline_id'];
	$onerow->name = $this->CreateLink($id, 'editpolyline', $returnid, $row['name'], array('polyline_id'=>$row['polyline_id']));
	$mapinfo = array();
	$mapinfo = $this->GetMapInformation($row['map_id']);
	$onerow->map = $this->CreateLink($id, 'editmap', $returnid, $mapinfo['name'], array('map_id'=>$row['map_id']));
	if (strstr($row['strokecolor'], '#') ) {
		$onerow->strokecolor = $row['strokecolor'];
	}
	else {
		$onerow->strokecolor = '#'.$row['strokecolor'];
	}
	$onerow->strokeopacity = $row['strokeopacity']; 
	$onerow->strokeweight = $row['strokeweight'];
	$onerow->example = '<div style="background-color: #FFF; width: 110px; height">&nbsp;
		<div style="width: 100px; background-color: '.$row['strokecolor'].';
		height:'.$row['strokeweight'].'px; vertical-align: -5px; 
		padding: 0 0 0 3px">&nbsp;
		</div>
		</div>';

	$onerow->editlink = $this->CreateLink($id, 'editpolyline', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('polyline_id'=>$row['polyline_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Polylines','polyline_id'=>$row['polyline_id']), $this->Lang('areyousure'));
	$onerow->exportlink = $this->CreateLink($id, 'exportpolyline_gpx', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/export.gif', $this->Lang('exporttogpx'),'','','systemicon'), array('polyline_id'=>$row['polyline_id'],'name'=>$row['name']));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));
// Retrieve the number of Global Content Blocks from user preferences (sorry this is a bit tricky)
$listgcbs_pagelimit = get_preference( $user_id, 'listgcbs_pagelimit' );
if ($listgcbs_pagelimit == 0 || $listgcbs_pagelimit == NULL) $listgcbs_pagelimit = 20;
$smarty->assign('pagelimit', $listgcbs_pagelimit);
#Setup links
$smarty->assign('addlink', $this->CreateLink($id, 'addpolyline', $returnid, $this->Lang('addpolyline'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addlink', $this->CreateLink($id, 'addpolyline', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newfolder.gif', $this->Lang('addpolyline'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addpolyline', $returnid, $this->Lang('addpolyline'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('import_local_link',$this->CreateLink($id, 'admin_import_local', $returnid, 
	$gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', 
	$this->Lang('importlocalpolyline'),'','','systemicon'), array(), '', false, false, '') .
	' '. $this->CreateLink($id, 'admin_import_local', $returnid, $this->Lang('importlocalpolyline'), array(), '',
	false, false, 'class="pageoptions"'));

$smarty->assign('title_name', $this->Lang('title_name'));
$smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$smarty->assign('title_example', $this->Lang('title_example'));
$smarty->assign('title_color', $this->Lang('title_color'));
$smarty->assign('title_opacity', $this->Lang('title_opacity'));
$smarty->assign('title_weight', $this->Lang('title_weight'));

#Display template
echo $this->ProcessTemplate('listpolylines.tpl');

?>