<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown 
#
# This function supports adding a polyline
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

if (!$this->CheckPermission('Use GoogleMaps'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'polylines');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$name = '';
if (isset($params['name']))
{
	$name = $params['name'];
}
$usedmap = '';
if (isset($params['map'])) {
	$usedmap = $params['map'];
}

$strokecolor = '';
if (isset($params['strokecolor'])) {
	$strokecolor = $params['strokecolor'];
}

$strokeopacity = '1.0';
if (isset($params['strokeopacity'])) {
	$strokeopacity = $params['strokeopacity'];
}
$strokeweight = '2';
if (isset($params['strokeweight'])) {
	$strokeweight = $params['strokeweight'];
}

$lat = '';
if (isset($params['lat'])) {
	$lat = $params['lat'];
}
else {
	$easylocatorlat = $this->GetPreference('easylocatorlat', 44);
}

$lon = '';
if (isset($params['lon'])) {
	$lon = $params['lon'];
}
else {
	$easylocatorlon = $this->GetPreference('easylocatorlon', -63);
}

$icon = '';
if (isset($params['icon'])) {
	$icon = $params['icon'];
}
$useddistanceuom = $this->GetPreference('distanceuom', 'K');
if (isset($params['useddistanceuom'])) {
	$useddistanceuom = $params['useddistanceuom'];
}

// Error checking
$errfnd = false;
$errorfound = '';
if (isset($params['submit'])) {
	if ($name == '') {
		$errfnd = true;
		$errorfound .= $this->Lang('nonamegiven');
	}
	if ($strokeopacity < 0 || $strokeopacity > 1) {
		$errfnd = true;
		if ($errorfound != '') {$errorfound .= '<br />';}
		$errorfound .= $this->Lang('invalidopacity');
	}
}
if (isset($params['submit']) && $errfnd == false) {
	$pladded = googlemaps_utils::insert_polyline($usedmap, $name, $strokecolor, 
		$strokeopacity, $strokeweight, 0, $useddistanceuom);

	$params = array('tab_message'=> 'polylineadded', 'active_tab' => 'polylines');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}
else {
	if ($errfnd) {
		echo $this->ShowErrors($errorfound);
	}
}

// Prepare default settings
switch ($this->GetPreference('defaultmaptype')) {
	case 'hybrid':
		$smarty->assign('maptype', 'HYBRID');
		break;
	case 'satellite':
		$smarty->assign('maptype', 'SATELLITE');
		break;
	case 'terrain':
		$smarty->assign('maptype', 'TERRAIN');
		break;
	default:
		$smarty->assign('maptype', 'ROADMAP');
		break;
}
$smarty->assign('used_lat', 0);
$smarty->assign('used_lon', 0);
$smarty->assign('used_icon', 0);

// Build path to color selector
$colorselectorpath = cms_join_path('..','modules',$this->getName(),'templates','201a.js');
$smarty->assign('colorselectorpath', $colorselectorpath);

// Prepare a list of maps
$maplist = array();
$maplist = googlemaps_utils::get_list_maps();

// Prepare a list of distance uom
$distanceuomlist = array();
$distanceuomlist = googlemaps_utils::get_distance_uom();

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addpolyline', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_name', $this->Lang('title_name'));
$smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 40, 80));
$smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$smarty->assign('input_belongstomap', $this->CreateInputDropdown($id, 'map', $maplist, -1, $usedmap));
$smarty->assign('title_color', $this->Lang('title_color'));
$smarty->assign('input_color', $this->CreateInputText($id, 'strokecolor', $strokecolor, 7, 7));
$smarty->assign('input_samplecolor', $this->CreateInputText($id, 'samplecolor', '', 1, 1, 'style="background-color: '.$this->GetPreference('strokecolor', '#FFFFFF').'"'));
$smarty->assign('title_opacity', $this->Lang('title_opacity'));
$smarty->assign('input_opacity', $this->CreateInputText($id, 'strokeopacity', $strokeopacity, 3, 3));
$smarty->assign('title_weight', $this->Lang('title_weight'));
$smarty->assign('input_weight', $this->CreateInputText($id, 'strokeweight', $strokeweight, 2, 2));
$smarty->assign('title_distanceuom', $this->Lang('title_distanceuom'));
$smarty->assign('input_distanceuom', $this->CreateInputDropdown($id, 'distanceuom', $distanceuomlist, -1, $useddistanceuom));

// Pass the id, so it can be used in the java script of the easylocator 
$smarty->assign('id',$id);
$smarty->assign('title_lat', $this->Lang('latitude'));
$smarty->assign('input_lat', $this->CreateInputText($id, 'lat', $lat, 40, 100));
$smarty->assign('title_lon', $this->Lang('longitude'));
$smarty->assign('input_lon', $this->CreateInputText($id, 'lon', $lon, 40, 100));

// Prepare the settings for the easylocator
$smarty->assign('editpolyline', '0');
$smarty->assign('title_locations', $this->Lang('title_locations'));
$smarty->assign('title_easylocator', $this->Lang('title_easylocator'));
$smarty->assign('easylocatorlat', $this->GetPreference('easylocatorlat', 44));
$smarty->assign('easylocatorlon', $this->GetPreference('easylocatorlon', -63));
$smarty->assign('easylocatorlevel', $this->GetPreference('easylocatorlevel'), 1);
$smarty->assign('easylocatorcursor', $this->GetPreference('easylocatorcursor', 'crosshair'));

$smarty->assign('hidden', '');
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('submitlocations', $this->CreateInputSubmit($id, 'submitlocations', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editpolyline.tpl');
?>