<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit();
if( !$this->CheckPermission('Manage Banners') ) exit;

// get the current category for the filter
$curcategory = get_preference(get_userid(),'banners_curcategory');
if( isset($params['submitcategory']) )
  {
    $curcategory =
      (isset ($params['input_category']) ? $params['input_category'] :
       '');
    set_preference(get_userid(),'banners_curcategory',$curcategory);
  }
  
// get a category list for the filter
$db = $this->GetDb();
$categorylist = array();
$query = "SELECT * FROM ".cms_db_prefix()."module_banners_categories
          ORDER BY name ASC";
  
$dbresult = $db->Execute( $query );
  
if( !$dbresult || $dbresult->RecordCount() == 0 ) 
  {
    $smarty->assign('error',1);
    $smarty->assign('message', $this->Lang('error_nocategories'));
    $smarty->assign ('addlink',
		     $this->CreateLink ($id, 'addcategory',
					$returnid,
					$this->
					Lang ('addcategory'),
					array (), '', false,
					false,
					'class="pageoptions"'));
  }
 else
   {
     while( $row = $dbresult->FetchRow() )
       {
	 if( $curcategory == '' )
	   {
	     $curcategory = $row['category_id'];
	   }
	 $categorylist[$row['name']] = $row['category_id'];
       }

     // setup the form part of the template
     $smarty->assign ('startform',
		      $this->CreateFormStart ($id, 'defaultadmin'));
     $smarty->assign ('category', $this->Lang ('category'));
     $smarty->assign ('input_category',
		      $this->CreateInputDropDown ($id, "input_category", $categorylist, -1,
						  $curcategory));
     $smarty->assign ('input_select',
		      $this->CreateInputSubmit ($id, 'submitcategory',
						$this->Lang('selectcategory')));
     $smarty->assign ('endform', $this->CreateFormEnd ());

     if( $curcategory != '' ) 
       {
	 // fill in the banners part of the report
	 $dbresult = '';
	 $rowarray = array();
	 $query = "SELECT * FROM ".cms_db_prefix()."module_banners WHERE category_id = ?
                    ORDER BY created";
	 $dbresult = $db->Execute( $query, array($curcategory));

	 $rowclass = 'row1';
	 if( ! $dbresult )
	   {
	     $smarty->assign('error',1);
	     $smarty->assign('message', $this->Lang('error_banners'));
	   }
	 else
	   {
	     $smarty->assign('idtext',$this->Lang('id'));
	     $smarty->assign('nametext',$this->Lang('name'));
	     $smarty->assign('desctext',$this->Lang('description'));
	     $smarty->assign('createdtext',$this->Lang('created'));
	     $smarty->assign('expirestext',$this->Lang('expires'));
	     $smarty->assign('impressionstext',$this->Lang('impressions'));
	     $smarty->assign('hitstext',$this->Lang('hits'));
	     while( $row = $dbresult->FetchRow() )
	       {
		 $onerow = new stdClass();

		 $q3 = "SELECT COUNT(banner_id) AS count FROM ".cms_db_prefix()."module_banners_hits
                      WHERE banner_id = ?";
		 $dbresult2 = $db->Execute( $q3, array( $row['banner_id'] ) );
		 if( $dbresult2 ) {
		   $r2 = $dbresult2->FetchRow();
		   if( $r2 ) {
		     $onerow->hits = $r2['count'];
		   }
		 }

		 $onerow->id = $row['banner_id'];
		 $onerow->name = $this->CreateLink( $id, 'editbanner', $returnid,
						    $row['name'],
						    array ('banner_id' => $row['banner_id'],
							   'category_id' => $curcategory));
						       
		 $onerow->description = $row['description'];
		 $onerow->created = $row['created'];
		 if( $row['expires'] == false )
		   {
		     $onerow->expires = $this->Lang('never');
		   }
		 else
		   {
		     $onerow->expires = $row['expires'];
		   }
		 $onerow->impressions = $row['num_impressions'];
		 $onerow->max_impressions = ($row['max_impressions'] == '') ? 0 : $row['max_impressions'];
		 $onerow->rowclass = $rowclass;
		    
		 $onerow->editlink =
		   $this->CreateLink ($id, 'editbanner', $returnid,
				      $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif',
										   $this->Lang ('edit'), '', '', 'systemicon'),
				      array ('banner_id' => $row['banner_id'],
					     'category_id' => $curcategory));
		    
		 $onerow->deletelink = 
		   $this->CreateLink ($id,'do_deletebanner',$returnid,
				      $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif',
										   $this->Lang ('delete'), '', '', 'systemicon'),
				      array ('banner_id' => $row['banner_id'],
					     'category_id' => $curcategory),
				      $this->Lang ('areyousure'));
		    
		 array_push ($rowarray, $onerow);
		 ($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
		    
	       } // while
	   } // if
	    
	 $smarty->assign('items',$rowarray);
	 $smarty->assign('itemcount', count($rowarray));
       } // if

     $smarty->assign ('addbanner',
		      $this->CreateImageLink ($id, 'addbanner', $returnid, $this->Lang ('addbanner'), 'icons/system/newobject.gif',
					      array ('category_id' => $curcategory), '', '', false));

     $smarty->assign ('report_url',
		      $this->CreateURL( $id, 'statsreport', $returnid, array('disable_theme'=>1) ));
     
   } // else
    
echo $this->ProcessTemplate('bannerlist.tpl');

?>