<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

if( !isset( $params['category'] ) ) 
  {
    $this->_DisplayErrorPage ($id, $params, $returnid,
			      $this->Lang ('error_insufficientparams'));
    return;
  }

$category_id=-1;
$category="";
{
  // lookup the category name and get the id
  $q2 = "SELECT * FROM ".cms_db_prefix()."module_banners_categories WHERE name = ?";
  $dbresult = $db->Execute( $q2, array( $params['category'] ) );
  if( !$dbresult ) 
    {
      $this->_DisplayErrorPage ($id, $params, $returnid,
				"ERROR: Could not find category ".
				$this->Lang ('error_dberror'));
      return;
    }
  $category = $dbresult->FetchRow();
  if( !$category ) 
    {
      $this->_DisplayErrorPage ($id, $params, $returnid,
				"ERROR: Could not find category (no rows) ".
				$this->Lang ('error_dberror'));
      return;
    }
  $category_id = $category['category_id'];
  $smarty->assign('category',$category);
}

// Now get all the non-expired banners in this category
$now = $db->DbTimeStamp(time());
$query = 'SELECT * FROM '.cms_db_prefix()."module_banners
           WHERE category_id = ? AND expires > $now
           AND ((num_impressions < max_impressions) OR (max_impressions = 0))";
$data = $db->GetArray($query,array($category_id));
if( $data ) 
  {
    for( $i = 0; $i < count($data); $i++ )
      {
	$row =& $data[$i];
	if( empty($row['text']) )
	  {
	    $row['text'] = 'Banner';
	  }
	$row['clickthrough'] = $this->CreateLink($id,'link',$returnid,'',
 			         array('banner_id'=>$row['banner_id'],
				     'category_id'=>$category_id),
					'', true);
      }
    $smarty->assign('banners',$data);
  }

echo $this->ProcessTemplateFromDatabase('bannerlist_template');

#
# EOF
#
?>