<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if (!$this->CheckPermission ('Manage Banners')) exit;

$this->SetCurrentTab('banners');

// are we cancelling
if (isset ($params['cancel']))
  {
    $this->RedirectToTab($id);
  }

$module = $this->_getUploadsModule();
$image = $params['input_image'];
if( $module && trim($image) == '')
  {
    // have to get the file name from 
    // the uploads pulldiwn thingy
    if( isset($params['input_upload_file']) && $params['input_upload_file'] > 0 )
      {
	$image = $module->getCategoryPathFromFileID($params['input_upload_file']);
	$image .= '/'.$module->getFileName($params['input_upload_file']);
      }
  }

// make sure we have something to work with
// make sure we have something to work with
if (!isset ($params['input_category_id']) || $params['input_category_id'] == "")
  {
    $message = $this->Lang ("error_insufficientparams");
    $error = true;
  }
 else if (!isset ($params['input_banner_id']) || $params['input_banner_id'] == "")
   {
     $message = $this->Lang ("error_insufficientparams");
     $error = true;
   }
 else if (!isset ($params['input_bannername'])
	  || $params['input_bannername'] == "")
   {
     $message = $this->Lang ("error_emptybannername");
     $error = true;
   }
 else if ($image == '')
   {
     $message = $this->Lang ("error_insufficientparams");
     $error = true;
   }
 else if (!isset ($params['input_url']) )
   {
     $message = $this->Lang ("error_insufficientparams");
     $error = true;
   }
 else if( !isset($params['input_neverexpires']) && !isset($params['expiresdate_Month']) )
   {
     $message = $this->Lang ("error_insufficientparams");
     $error = true;
   }
 else
   {
     $expires_ut = 0;
     if( !isset( $params['input_neverexpires'] ) )
       {
	 $expires_ut = mktime(23,59,55,
			      $params['expiresdate_Month'], $params['expiresdate_Day'], $params['expiresdate_Year']);
       }
     $expires = ($expires_ut == 0) ? 'NULL' : $db->DBTimeStamp($expires_ut);
     
     $startdate_ut = mktime(0,0,0,
			    $params['startdate_Month'], $params['startdate_Day'], $params['startdate_Year']);
     $startdate = $db->DbTimeStamp($startdate_ut);
     
     if( ($expires_ut > 0) && ($expires_ut < $startdate_ut) )
       {
	 $message = $this->Lang('error_invalid_dates');
	 $error = true;
       }
     else
       {
	 $query = "UPDATE ".cms_db_prefix()."module_banners
                      SET name = ?, description = ?, image = ?, url = ?,
                          text = ?, expires = $expires, max_impressions = ?,
                          href_text = ?, start_date = $startdate
                    WHERE category_id = ? AND banner_id = ?";
	 $dbresult =
	   $db->Execute ($query,
			 array ( $params["input_bannername"],
				 $params["input_bannerdesc"],
				 $image,
				 $params["input_url"],
				 $params['input_image_text'],
				 $params['input_max_impressions'],
				 $params['input_href_text'],
				 $params['input_category_id'],
				 $params['input_banner_id']
				 ));
	 if (!$dbresult)
	   {
	     $smarty->assign ('message',$this->Lang ("error_dberror"));
	     $error = true;
	   }
       }
   }

if (isset($error))
  {
    $this->SetError($message);
    $this->Redirect($id,'editbanner',$returnid, 
		    array('banner_id' => $params['input_banner_id'], 'category_id' => $params['input_category_id']));
  }
 else
   {
     $this->RedirectToTab($id);
   }

?>
