<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009 by Duketown <duketown@mantox.nl>
#
# This function supports the back end for the module birthday listing
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (! $this->CheckAccess('Use Birthday Listings')) {
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

if (isset($params['active_tab'])) {
	$tab = $params['active_tab'];
}
$themeObject = &$gCms->variables['admintheme'];

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

echo $this->StartTabHeaders();
	echo $this->SetTabHeader('birthdays',$this->Lang('title_birthdays'), ('birthdays' == $tab)?true:false);
	if( $this->CheckPermission('Modify Templates') )
	{
		echo $this->SetTabHeader('templates',$this->Lang('templates'), ('templates' == $tab)?true:false);
	}
	if ($this->CheckAccess('Modify Site Preferences')) {
		echo $this->SetTabHeader('options',$this->Lang('title_options'), ('options' == $tab)?true:false);
	}
echo $this->EndTabHeaders();

// The content of the tabs
echo $this->StartTabContent();
{
	// --- Start tab birthdays ---
	echo $this->StartTab('birthdays');
		include(dirname(__FILE__).'/function.admin_birthdaystab.php');

	echo $this->EndTab();
	// --- End tab birthdays ---

	// --- Start tab templates ---
	if ($this->CheckPermission('Modify Templates'))	{
		
		echo $this->StartTab('templates');
		include(dirname(__FILE__).'/function.admin_templatestab.php');
		
		echo $this->EndTab();
	}
	// --- End tab templates ---

	// --- Start tab opties ---
	if ($this->CheckAccess('Modify Site Preferences')) {
		echo $this->StartTab('options');
		// Display the options
		include(dirname(__FILE__).'/function.admin_optionstab.php');
		echo $this->EndTab();
	}
	// --- End tab opties ---

}
echo $this->EndTabContent();

?>