<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

require_once dirname(__FILE__).'/../OpenID.module.php';
require_once 'Auth/OpenID/DatabaseConnection.php';

class CMSMSDatabaseConnection extends Auth_OpenID_DatabaseConnection {

    /**
     *
     * @global CmsObject $gCms
     * @return ADOConnection
     */
    private static function _GetDb() {
        global $gCms;
        return $gCms->GetDb();
    }

    public function autoCommit($mode) {
        OpenID::Log("autoCommit : ".$mode);
        CMSMSDatabaseConnection::_GetDb()->autoCommit = $mode;
    }

    public function begin() {
        OpenID::Log("begin transaction called but disabled : http://dev.cmsmadesimple.org/bug/view/7596");
        //CMSMSDatabaseConnection::_GetDb()->BeginTrans();
    }

    public function commit() {
        OpenID::Log("commit transaction called but disabled : http://dev.cmsmadesimple.org/bug/view/7596");
        //CMSMSDatabaseConnection::_GetDb()->CommitTrans();
    }

    public function getAll($sql, $params = array()) {
        OpenID::Log("getAll : ".$sql." ".print_r($params, TRUE));
        $dbresult = CMSMSDatabaseConnection::_GetDb()->Execute($sql, $params);
        $result = array();
        while ($dbresult && !$dbresult->EOF) {
            $fields = & $dbresult->fields;
            $row = array();
            foreach ($fields as $key => $value) {
                $row[$key] = $value;
            }
            $result[] = $row;
            $dbresult->MoveNext();
        }
        OpenID::Log("result : ".print_r($result, TRUE));
        return $result;

    }

    public function getOne($sql, $params = array()) {
        OpenID::Log("getOne : ".$sql." ".print_r($params, TRUE));
        $result = CMSMSDatabaseConnection::_GetDb()->GetOne($sql, $params);
        OpenID::Log("result : ".print_r($result, TRUE));
        return $result;
    }

    public function getRow($sql, $params = array()) {
        OpenID::Log("getRow : ".$sql." ".print_r($params, TRUE));
        $dbresult = CMSMSDatabaseConnection::_GetDb()->Execute($sql, $params);
        $result = array();
        if ($dbresult && !$dbresult->EOF) {
            $fields = & $dbresult->fields;
            foreach ($fields as $key => $value) {
                $result[$key] = $value;
            }
        }
        OpenID::Log("result : ".print_r($result, TRUE));
        return $result;
    }

    public function query($sql, $params = array()) {
        OpenID::Log("query : ".$sql." ".print_r($params, TRUE));
        $result =& CMSMSDatabaseConnection::_GetDb()->Execute($sql, $params);
        OpenID::Log("result : ".print_r($result, TRUE));
        return $result;
    }

    public function rollback() {
        OpenID::Log("rollback transaction");
        CMSMSDatabaseConnection::_GetDb()->RollbackTrans();
    }


}

?>
