<?php
$lang['friendlyname'] = 'OpenID Module';
$lang['postinstall'] = 'OpenID modules installed';
$lang['postuninstall'] = 'OpenID module uninstalled"';
$lang['really_uninstall'] = 'Are you sure you want to uninstall the OpenID module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'This module adds OpenID login capabilities to CMS Made Simple and FrontEndUsers.';
$lang['changelog'] = 'See wiki at <a href="https://bitbucket.org/henriklen/openid/wiki/">https://bitbucket.org/henriklen/openid/wiki/</a>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>The OpenID module provides functionality to add an OpenID or Facebook account to a registered frontend user. That user can then log in using that identity instead of the ordinary frontend account.</p>
<h3>How Do I Use It</h3>
<p><ol>
    <li>Make sure that FrontEndUsers is installed</li>
    <li>Install the OpenID module</li>
    <li>Check out the settings page if you want to use Facebook as a provider</li>
    <li>Add the tag <i>{OpenID}</i> to a new or an existing page</li>
    <li>Log in as an already registered frontend user</li>
    <li>Visit the page with the OpenID tag and register a provider</li>
    <li>Logout</li>
    <li>Revisit the page with the OpenID tag, select the same provider you just registered, authenticate and behold: You are now logged in</li>
</ol></p>
<h3>Support</h3>
<p>Check out the wiki for FAQ and additional information: <a href="https://bitbucket.org/henriklen/openid/wiki/">https://bitbucket.org/henriklen/openid/wiki/</a><p>
<p>Getting OpenID to work properly can be a bit of a struggle if you are not
fortunate enough to have an environment that already has all the bits and pieces in place.
<br/>Some places to check before asking for help:<br/>
<ul>
    <li>The janrain README file in the /modules/OpenID/openid-php-openid-*version* directory</li>
    <li>Run the detect.php file in /modules/OpenID/openid-php-openid-*version*/examples/</li>
    <li>Try different OpenID providers in order to determine if all are broken or just some.
    A rule of thumb is that Facebook is a separate thing compared to the OpenID providers.
    Providers that use discovery (like Google) is different from the simpler ones like myOpenID</li>
    <li>Check your php error logs for any exceptions or error messages. Google any output for clues about how to solve them</li>
    <li>Set openid.debug to true in your config.php. This will output a ton of messages to the php error log</li>
</ul>
</p>
<h3>Credits</h3>
<p>The OpenID library is standing on the shoulders of giants, namely:
<ul>
    <li><a href="http://github.com/openid/php-openid/" target="_blank">PHP OpenID library by JanRain, Inc.</a></li>
    <li><a href="http://jvance.com/pages/JQueryOpenIDPlugin.xhtml" target="_blank">OpenID jQuery plugin by Jarret Vance</a></li>
    <li><a href="https://github.com/facebook/facebook-php-sdk" target="_blank">Facebook PHP SDK</a></li>
    <li><a href="http://www.jquery.com" target="_blank">jQuery</a></li>
</ul>
</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2010-2012, <a href="mailto:openid@lennartssons.net">Henrik Lennartsson</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.apache.org/licenses/LICENSE-2.0.html">Apache License Version 2.0</a>. You must agree to this license before using the module.</p>
';
$lang['openid_providers'] = 'Enabled providers';
$lang['settings'] = 'Settings';
$lang['users'] = 'Users';
$lang['submit'] = 'Submit';
$lang['cancel'] = 'Cancel';
$lang['openid_fail'] = 'Your provided identity is <a href="%s">%s</a> but the login failed';
$lang['openid_success'] = 'Your provided identity is <a href="%s">%s</a> and you have been logged in as user %s';
$lang['openid_unknown'] = 'Your provided identity is <a href="%s">%s</a> but is not registered with any user.';
$lang['openid_redirecting'] = 'Please wait, redirecting to your selected OpenID provider';
$lang['openid_added_identity'] = 'Successfully added %s identity %s';
$lang['openid_remove_identity_success'] = 'Successfully removed identity';
$lang['openid_remove_identity_failed'] = 'Could not remove identity';
// list_providers
$lang['list_registered_providers'] = 'Registered providers';
$lang['list_information'] = 'The following OpenID providers have been associated with your account. You can use any one to log in to this site.';
$lang['list_link_remove'] = 'Remove';
$lang['list_add'] = 'Add or update provider';
$lang['list_add_information'] = 'Select a provider in the form and complete the signin process. If successful the provider will be added to your list of registered providers.
    If you\'ve already got another id registered with the same provider that ID will be replaced.';
// login_form
$lang['login_enter_your'] = 'Enter your';
$lang['login_provider_user_name'] = 'Provider user name';
$lang['login_openid'] = 'OpenID';
$lang['login_login'] = 'Login';
// login_form_openid_selector
$lang['login_signin'] = 'Sign-in';
$lang['login_click_provider'] = 'Please click to select your account provider';
$lang['login_openid_information'] = 'OpenID is service that allows you to log-on to many different websites using a single indentity.
 Find out <a href="http://openid.net/what/">more about OpenID</a> and <a href="http://openid.net/get/">how to get an OpenID enabled account</a>';
// register_provider
$lang['register_provider'] = 'Register OpenID provider';
$lang['register_information'] = 'Select your OpenID provider in the form below and complete the sign in process.
Once completed your user account on this site will be associated with your
OpenID provider. This makes it possible for you to sign in using OpenID instead
of username and password.';
// twitter
$lang['twitter_failed_or_canceled'] = 'Twitter login was cancelled or failed for some other reason';
// facebook
$lang['facebook_failed_or_canceled'] = 'Facebook login was cancelled or failed for some other reason';
?>
