<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */


/* @var $this OpenID */
/* @var $gCms CmsObject */

function CreateProviderInput($provider, $module, $enabled = TRUE) {
    global $smarty;
    $id = null;
    $checkbox = RRUtils::myCreateInputCheckbox($id, 'input_provider_'.$provider, 1, OpenIDUtils::IsEnabled($provider, $module));
    if (!$enabled) {
        $checkbox = str_replace('type=','disabled type=', $checkbox);
    }
    $smarty->assign('input_'.$provider,
		$checkbox);
}

$smarty->assign('startform',
		$this->CreateFormStart( $id, 'admin_updateproviders'));
$smarty->assign('endform', $this->CreateFormEnd());

CreateProviderInput('google', $this);
CreateProviderInput('yahoo', $this);
CreateProviderInput('aol', $this);
CreateProviderInput('myopenid', $this);
CreateProviderInput('myspace', $this);
CreateProviderInput('flickr', $this);
$facebookConfigured = strlen($this->GetPreference('facebook_app_id','')) + strlen($this->GetPreference('facebook_app_secret','')) > 0;
CreateProviderInput('facebook', $this, $facebookConfigured);
$twitterConfigured = strlen($this->GetPreference('twitter_consumer_key','')) + strlen($this->GetPreference('twitter_consumer_secret','')) > 0;
CreateProviderInput('twitter', $this, $twitterConfigured);
CreateProviderInput('twitter_small', $this, $twitterConfigured);
CreateProviderInput('technorati', $this);
CreateProviderInput('wordpress', $this);
CreateProviderInput('blogger', $this);
CreateProviderInput('livejournal', $this);
CreateProviderInput('claimid', $this);
CreateProviderInput('vidoop', $this);
CreateProviderInput('verisign', $this);

$smarty->assign('submit',
		$this->CreateInputSubmit ($id, 'submit',
					  $this->Lang('submit'),'',''));
$smarty->assign ('cancel',
		 $this->CreateInputSubmit ($id, 'cancel',
					   $this->Lang('cancel')));

echo $this->ProcessTemplate('admin_tab_providers.tpl');
?>
