<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
if (!isset($gCms))
    exit;
global $params;
$this->Log("********************************");
$this->Log(" *** ".__FILE__);


global $gCms;
$smarty = & $gCms->GetSmarty();

require_once dirname(__FILE__) . "/oauth-php_1_7_5/library/OAuthStore.php";
require_once dirname(__FILE__) . "/oauth-php_1_7_5/library/OAuthRequester.php";

// Create link to action.twitter.callback.php (don't use xhtml encoding)
$callbackUrl = str_replace('amp;', '', $this->CreateLink($id, 'twitter_callback', $returnid, null, null, null, true, true, null, null));
$this->Log("Twitter callback URL : $callbackUrl");
try {
    $options = array(
        'consumer_key' => $this->GetPreference('twitter_consumer_key', ''),
        'consumer_secret' => $this->GetPreference('twitter_consumer_secret', ''),
        'oauth_callback' => $callbackUrl);
    // Create session based store
    OAuthStore::instance("Session", $options);
    // Get request token
    $request = new OAuthRequester("https://twitter.com/oauth/request_token", "POST", $options);
    $result = $request->doRequest(0);
    parse_str($result['body'], $params);
    $this->Log('Twitter request token result = ' . print_r($result, true));
    // Create request based on token
    $request = new OAuthRequester("https://twitter.com/oauth/authenticate", 'GET', $params);
    // Generate URL and redirect user
    $url = 'https://twitter.com/oauth/authenticate?' . $request->getNormalizedParams() . '&oauth_callback=' . $callbackUrl;
    $this->Log('Redirecting user to '.$url);
    header("Location: $url");
} catch (OAuthException2 $e) {
    echo "Exception" . $e->getMessage();
}

?>