<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
if (!isset($gCms))
    exit;
global $params;
$this->Log("********************************");
$this->Log(" *** " . __FILE__);


global $gCms;
$smarty = & $gCms->GetSmarty();

require_once dirname(__FILE__) . "/oauth-php_1_7_5/library/OAuthRequester.php";

$options = array_merge(
                array(
                    'consumer_key' => $this->GetPreference('twitter_consumer_key', ''),
                    'consumer_secret' => $this->GetPreference('twitter_consumer_secret', '')),
                $_GET);
OAuthStore::instance("Session", $options);
try {
    $request = new OAuthRequester("https://api.twitter.com/oauth/access_token", "POST", $options);
    $result = $request->doRequest(0);
} catch (Exception $e) {
    $this->Log('twitter callback exception '.print_r($e, true));
    print $this->Lang('twitter_failed_or_canceled', $screenName, $screenName);
    return;
}
parse_str($result['body'], $params);
$this->Log('result = ' . print_r($result, true));

$userId = $params['user_id'];
$screenName = $params['screen_name'];
if ($userId) {
    try {

        /* @var $feu FrontEndUsers */
        $feu = $this->GetModuleInstance('FrontEndUsers');
        if ($feu->LoggedIn()) {
            $this->Log("Registering user " . $userId . " (" . $screenName . ") as Twitter identity");
            // User is logged in: Add Twitter identifer as user identity
            $this->RegisterOpenID($feu->LoggedInId(), 'twitter:' . $userId, $screenName);
            // Add message and display list of providers
            $smarty->assign('message', $this->Lang('openid_added_identity', 'Twitter', $screenName ? $screenName : $userId));
            $smarty->assign('message_type', 'success');
            include 'action.default.php';
        } else {
            $this->Log("Logging in twitter user " . $userId . " (" . $screenName . ")");
            // User is not logged in: Try to login user
            $uid = $this->GetUserId('twitter:' . $userId);
            $this->Log("UID = " . $uid);
            $userinfo = $feu->GetUserInfo($uid);
            if ($userinfo[0]) {
                $username = $userinfo[1]['username'];
                $password = $userinfo[1]['password'];
                $this->Log("username/password : " . $username . " " . $password);
                $result = $feu->Login($username, $password, '', true, true);
                $this->Log('Login message : ' . $result[1]);
                if (!$result) {
                    print $this->Lang('openid_fail', $screenName, $screenName);
                } else {
                    // Redirect or display message
                    $redirectPageId = $this->GetRedirectLoginPageId();
                    if (!$redirectPageId) {
                        print $this->Lang('openid_success', $screenName, $screenName, $username);
                    } else {
                        $this->RedirectContent($redirectPageId);
                    }
                    return;
                }
            } else {
                $this->Log("Error while fetching userinfo for " . $uid . " : " . $userinfo[1]);
                print $this->Lang('openid_unknown', $screenName, $screenName);
            }
        }
    } catch (OAuthException2 $e) {
        $this->Log($e);
    }
}
?>