<h3>What Does This Do?</h3>
<p>This module provides the ability to build and manage RSS Feeds consisting of data from any CMS Made Simple module that supports a summary view.</p>
<p>It supports categorizing the feeds, generating auto-discovery links, and standalone links to rss feeds.</p>
<p>Pretty URL's are supported if your site has them enabled. - <em>ex:</em> http://www.yoursite.com/feeds/Feed-Name</p>
<h3>How Do I Use It?</h3>
<ul>
<li>-First you must create a new feed, and fill in the parameters supplied.
  <p>A template is associated with each feed.  The default template illustrates how to generate an RSS feed from the News module</p>
  <p>To generate templates from other feeds you will need to use the template variables from that module. Put {get_template_vars} in a page that uses that module to see which variables you can call into your Feed Template. To control the output of your feed you need to use a combination of these template variables and modify your module call in the template.</p>
</li>
<li>-Secondly you should place an auto-discovery tag in the appropriate place.
  <p>This will create auto-discovery links in your output.  You can place this tag in the head section of the page template, or the metadata section of specific pages to generate autodiscovery.  Various parameters can be specified to control which feeds auto-discovery links are generated for.<br /></p>
<p>  
<em>ex1:</em> <strong>{CGFeedMaker action='autodiscovery' feed='myFeed1,myFeed2 '}</strong> - This creates autodiscovery links for all specified feeds<br />
<em>ex2:</em> <strong>{CGFeedMaker action='autodiscovery' category='myCategory1,myCategory2'}</strong> - This creates autodiscovery links for all feeds in the specified category or categories</p>
</li>
  <li>-Thirdly, you can place links to specific feeds in your content.  using the action=rsslink parameter.<p>This will create a link to the specified feed in the location you put the call.</p>
  <p><em>ex1:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed'}</strong> - Generic "rsslink" call
  <br/>
  <em>ex2:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed' imageonly='' image='uploads/images/rssNew.jpg' imageclass='rssImage'}</strong> - This call displays a link that shows only an Image for the link, it specifies a different image that was uploaded to use for the link than the default image and it uses a different CSS class to format the image (specified in one of your stylesheets)  
  <br />
   <em>ex3:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed' text='RSS News Feed' image='uploads/images/rssNew.jpg' imageclass='rssImage' linkclass="rssLink"}</strong> - This call specifies different text for the link to the feed, specifies a new image to be used and uses different CSS classes to format the Image and Link (specified in one of your stylesheets)   </p> 
  </ul>
<h3>Notes:</h3>
<ul>
<li>This module will work best, and the default feeds will validate if you have configured pretty urls properly.   Otherwise, atom links seem to have problems with some of our URLS.</li>
</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy's
homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>