<?php
#-------------------------------------------------------------------------
# Module: Notifications
# Version: 1.0, Tapio Lytty stikki@cmsmadesimple.org
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2007 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class ntfs_handler
{

	#---------------------
	# Magic methods
	#---------------------		
	
	private function __construct() {}
	
	#---------------------
	# Database methods
	#---------------------	
	
	static final public function Save(ntfsNotification &$obj)
	{
		$db = cmsms()->GetDb();
	
		$time = $db->DBTimeStamp(time());
			
		if ($obj->id > -1) {
		
			$query = "UPDATE ".cms_db_prefix()."module_notifications_items SET name = ?, description = ?, subject = ?, from_address = ?, to_address = ?, message_html = ?, message_plain = ?, code = ?, modified_date = ".$time." WHERE id = ?";
			$dbresult = $db->Execute($query, array($obj->name, $obj->description, $obj->subject, $obj->from_address, $obj->to_address, $obj->message_html, $obj->message_plain, $obj->code, $obj->id));
			
		} else {

			$query = "INSERT INTO ".cms_db_prefix()."module_notifications_items (name, description, subject, from_address, to_address, message_html, message_plain, code, create_date, modified_date) VALUES (?,?,?,?,?,?,?,?,".$time.",".$time.")";
			$dbresult = $db->Execute($query, array($obj->name, $obj->description, $obj->subject, $obj->from_address, $obj->to_address, $obj->message_html, $obj->message_plain, $obj->code));
			$newid = $db->Insert_ID();

			if ($newid > -1) {
			
				$obj->id = $newid;
			}	
		}
		
		// Drop old events
		$query = "DELETE FROM ".cms_db_prefix()."module_notifications_events WHERE notification_id = ?";	
		$dbresult = $db->Execute($query, array($obj->id));
		
		// Update events
		foreach($obj->events as $eventid) {
		
			$query = "INSERT INTO ".cms_db_prefix()."module_notifications_events (notification_id, event_id) VALUES (?,?)";
			$dbresult = $db->Execute($query, array($obj->id, $eventid));		
		}

	}

	static final public function Delete(ntfsNotification &$obj)
	{
		$db = cmsms()->GetDb();

		if ($obj->id > 0) {

			// Delete from items
			$query = "DELETE FROM ".cms_db_prefix()."module_notifications_items WHERE id = ?";
			$dbresult = $db->Execute($query, array($obj->id));
			
			// Delete from events
			$query = "DELETE FROM ".cms_db_prefix()."module_notifications_events WHERE notification_id = ?";	
			$dbresult2 = $db->Execute($query, array($obj->id));			
				
			if ($dbresult && $dbresult2) {
			
				$obj->__construct();
				return true;
			}
		}

		return FALSE;
	}
	
	static final public function Load(ntfsNotification &$obj, $id)
	{
		$db = cmsms()->GetDb();

		$query = "SELECT * FROM ".cms_db_prefix()."module_notifications_items WHERE id = ?";
		$row = $db->GetRow($query, array($id));

		if ($row) {
		
			$obj->id = $row['id'];
			$obj->name = $row['name'];
			$obj->description = $row['description'];
			$obj->subject = $row['subject'];
			$obj->from_address = $row['from_address'];
			$obj->to_address = $row['to_address'];
			$obj->message_html = $row['message_html'];
			$obj->message_plain = $row['message_plain'];
			$obj->created = $row['create_date'];
			$obj->modified = $row['modified_date'];
		
			// Overloaded
			$obj->events = self::LoadEvents($obj);
			$obj->code = $row['code'];
						
			return true;
		}

		return FALSE;
	}	

	static final public function LoadEvents(ntfsNotification &$obj)
	{
		$db = cmsms()->GetDb();	
	
		$result = array();
	
		$query = "SELECT event_id FROM ".cms_db_prefix()."module_notifications_events WHERE notification_id = ?";
		$dbresult = $db->Execute($query, array($obj->id));

		while ($dbresult && $row = $dbresult->FetchRow()) {
		
			$result[] = $row['event_id'];
		}
		
		return $result;
		
	}
	
} // end of class

?>