<?php
#-------------------------------------------------------------------------
# Module: Notifications
# Version: 1.0, Tapio Lytty stikki@cmsmadesimple.org
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2007 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class ntfsNotification
{
	#---------------------
	# Attributes
	#---------------------

	public $id;
	public $name;
	public $description;
	public $subject;
	public $from_address;
	public $to_address;
	public $message_html;
	public $message_plain;
	public $created;
	public $modified;
	
	private $_full;
	private $_data = array();
	private static $_keys = array('code','events');
	private static $_ui_keys = array('editlink','deletelink');
	
	#---------------------
	# Magic methods
	#---------------------		
	
	public function __construct($full = true)
	{	
		$this->id = -1;
		$this->name = '';
		$this->description = '';
		$this->subject = '';
		$this->from_address = '';
		$this->to_address = '';
		$this->message_html = '';
		$this->message_plain = '';
		$this->created = '';
		$this->modified = '';	

		$this->_full = $full;
	}
	
	public function __get($key)
	{
		if((in_array($key, self::$_keys) && isset($this->_data[$key]) && $this->_full) || // <- Check against Overload keys
			(in_array($key, self::$_ui_keys) && isset($this->_data[$key]))) { // <- Check against UI Overload keys
		
			return $this->_data[$key];
		}
	}

	public function __set($key,$value)
	{
		if((in_array($key, self::$_keys) && $this->_full) || // <- Check against Overload keys
			(in_array($key, self::$_ui_keys))) { // <- Check against UI Overload keys
		
			$this->_data[$key] = $value;
		}
	}	

} // end of class

?>