<?php
$lang['modulename'] = 'Notifications ';
$lang['module_description'] = 'Notifications Module is a flexible Mailing system in CMSMS backend.';
$lang['postuninstall'] = 'Le module Notifications a &eacute;t&eacute; d&eacute;sinstall&eacute;';
$lang['postinstall'] = 'Le module Notifications a &eacute;t&eacute; install&eacute;';
$lang['preuninstall'] = '&Ecirc;tes vous s&ucirc;re(e) de vouloir d&eacute;sinstaller Notifications ?';
$lang['are_you_sure'] = 'Supprimer cet item ?';
$lang['title_notifications'] = 'Notifications ';
$lang['title_options'] = 'Options ';
$lang['text_additem'] = 'Ajouter un item';
$lang['text_advanced_information'] = 'Basculer vers information avanc&eacute;e';
$lang['title_advanced_information'] = 'Variables disponibles';
$lang['title_notification_object'] = 'Objet de la notification';
$lang['text_notification_object'] = '<ul>
    <li>$notification->id</li>
    <li>$notification->name</li>
    <li>$notification->description</li>
    <li>$notification->subject</li>
    <li>$notification->from_address</li>
    <li>$notification->to_address</li>
    <li>$notification->message_html</li>
    <li>$notification->message_plain</li>
    <li>$notification->create_date</li>
    <li>$notification->modified_date</li>
</ul>';
$lang['title_event_parameters'] = 'Param&egrave;tres &eacute;v&eacute;nements';
$lang['text_event_parameters'] = '<ul>
    <li>$eventparams</li>
    <li>$originator</li>
    <li>$eventname</li>
</ul>';
$lang['text_notice_description'] = '<strong>NOTA :</strong> {$notification} et {$eventparams} utilisable dans ce champ';
$lang['submit'] = 'Envoyer';
$lang['cancel'] = 'Annuler';
$lang['permission'] = 'Permission ';
$lang['description'] = 'Description ';
$lang['notification'] = 'Notification ';
$lang['name'] = 'Nom';
$lang['subject'] = 'Suject';
$lang['status'] = 'Statut';
$lang['delete'] = 'Supprimer';
$lang['edit'] = 'Editer';
$lang['back'] = 'Retour';
$lang['from_address'] = 'From adresse';
$lang['to_address'] = 'To adresse';
$lang['message_html'] = 'Message au format HTML';
$lang['message_plain'] = 'Message en mode text';
$lang['code'] = 'Code ';
$lang['events'] = 'Ev&eacute;nements';
$lang['basic'] = 'Basique';
$lang['advanced'] = 'Avanc&eacute;';
$lang['itemdeleted'] = 'La notification a &eacute;t&eacute; supprim&eacute;e';
$lang['itemsaved'] = 'La notification a &eacute;t&eacute; sauvegard&eacute;e.';
$lang['error_fieldempty'] = 'Champ %s vide';
$lang['help'] = '<h3>What does this module do?</h3>
<p>Notifications Module is a flexible Mailing system in CMSMS backend.</p>
<p>It sends out Email notifications on easy to setup events that are available in EventManager. Email Templates are fully customizable as well as Email Recipients or Sender. <br />
Within &quot;Advanced&quot; section it is possible to customize notification object with custom PHP code in the same familiar way as within UDT&#039;s.</p>
<h3>How do i use it?</h3>
<p>Using Notifications is fairly straight forward. After Module was installed you will find it unter &quot;Extensions &raquo; Notifications&quot;.</p>
<p>To create a notification add new notification item and configure it to your needs.<br />
In the notification interface you will be able to select a Event available from Event Manager module on which email should be sent.<br />
In &quot;Subject&quot;, &quot;Message in HTML Format&quot; and &quot;Message in PLAIN Text&quot; you can compose your email Subject and Content where  <code>{$notification}</code> and <code>{$eventparams}</code> variables are available.</p>
<p>Within &quot;Advanced&quot; tab you are also able to optimize notification object with some custom PHP code</p>
<p><strong>Example:</strong></p>
<p>If you have FrontEndUsers Module installed and would like to send personalized message to a user after log in.<br />
Code below would assume that you have first_name and last_name user properties set up in FrontEndUsers module.</p>
<pre><code>
// get FEU module
$feu = cmsms()->GetModuleInstance(&#039;FrontEndUsers&#039;);
// get smarty
$smarty = cmsms()->GetSmarty();

// send a message to email address (assuming email is used as username)    
$notification->to_address =  $feu->GetUserName($feu->LoggedInId());

// get user proerties
foreach ($feu->GetUserProperties($feu->LoggedInId()) as $prop) {
    $user_props[$prop[&#039;title&#039;]] = $prop[&#039;data&#039;];
}

// pass properties to smarty
$smarty->assign(&#039;first_name&#039;, $user_props[&#039;first_name&#039;]);
$smarty->assign(&#039;last_name&#039;, $user_props[&#039;last_name&#039;]);
</code></pre>
<br /><p>After this you would have <code>{$first_name}</code> and <code>{$last_name}</code> variables available in the Notification message fields and &quot;To address&quot; would already be specified.<br />
Now you could send for example daily offers or some greeting to a User after login</p>
<p><strong>Example:</strong></p>
<pre><code>
&lt;h1&gt;Welcome{if !empty($first_name)} {$first_name}{/if}{if !empty($last_name)} {$last_name}{/if}&lt;/h1&gt;,

&lt;p&gt;how is your day today&lt;/p&gt;.
&lt;p&gt;We have some great new offers for you today.... and so on...&lt;/p&gt;
</code></pre>
';
?>