<?php  
#-------------------------------------------------------------------------
# Module: Notifications
# Version: 1.0, Tapio Löytty stikki@cmsmadesimple.org
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2007 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class Notifications extends CMSModule
{

	#---------------------
	# Attributes
	#---------------------	


	#---------------------
	# Magic methods
	#---------------------	

	public function __construct()
	{
		parent::__construct();
	}

	#---------------------
	# Module API methods
	#---------------------	

	function GetName()
	{
		return 'Notifications';
	}

	function GetFriendlyName()
	{
		return $this->Lang('modulename');
	}

	function GetDependencies()
	{
		return array('CMSMailer'=>'2.0.2');
	}

	function AllowAutoInstall()
	{
		return false;
	}

	function AllowAutoUpgrade()
	{
		return false;
	}

	function IsPluginModule()
	{
		return false;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetVersion()
	{
		return '1.0';
	}

	function MinimumCMSVersion()
	{
		return '1.9';
	}

	function GetAdminDescription()
	{
		return $this->Lang('module_description');
	}

	function VisibleToAdminUser()
	{
		return $this->CheckPermission('Use Notifications');
	}

	public function LazyLoadFrontend()
	{
		return FALSE;
	}  

	public function LazyLoadAdmin()
	{
		return FALSE;
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('preuninstall');
	}

	function GetHelp($lang='en_US')
	{
		return $this->Lang('help');
	}

	function GetAdminSection()
	{
		return 'extensions';
	}

	function GetAuthor()
	{
		return 'Stikki';
	}

	function GetAuthorEmail()
	{
		return 'stikki@cmsmadesimple.org';
	}
	
	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.html');
	}

    public function GetHeaderHTML()
    {
        $module_dir = $this->GetModuleURLPath();
        $tmpl = <<<EOT
<link type="text/css" rel="stylesheet" href="{$module_dir}/css/style.css"></link>
<script type="text/javascript" src="{$module_dir}/js/functions.js"></script>
EOT;
        return $this->ProcessTemplateFromData($tmpl);
    }	

	function DoAction($name,$id,$params,$returnid='')
	{
		$smarty = cmsms()->GetSmarty();

		$smarty->assign_by_ref('mod',$this);
		$smarty->assign('actionid',$id);
		$smarty->assign('returnid',$returnid);
		
		parent::DoAction($name,$id,$params,$returnid);
	}

	function DoEvent($originator, $eventname, &$params)
	{
		$items = $this->GetItems(false); // <- Do not load Overload properties
		foreach($items as $item) {
	
			$itemevents = ntfs_handler::LoadEvents($item); // <- Gotta load directly from handler, cause $this->events dosen't exists in this instance.
			foreach($itemevents as $eventid) {
	
				$event = $this->GetEventById($eventid);
				if ($originator == $event['originator'] && $eventname == $event['event_name']) {

					// Email sending & object altering goes here
					$this->EvalCode($item, $originator, $eventname, $params);
					$this->SendNotification($item, $params); // <- Add some sort of error reportit, audit or something.	
				}		
			}
		}
	}

	#---------------------
	# Manipulation methods
	#---------------------
	
	private function EvalCode(ntfsNotification &$notification, $originator, $eventname, &$eventparams)
	{
		$db = cmsms()->GetDb();

		$query = "SELECT code FROM ".cms_db_prefix()."module_notifications_items WHERE id = ?";
		$code = $db->GetOne($query, array($notification->id));
		
		if($code) {
		
			@eval($code);
		}
	}	
	
	#---------------------
	# Item methods
	#--------------------- 	
	
	public function GetItems($full = true)
	{
		$db = cmsms()->GetDb();

		$result = array();

		$query = "SELECT id FROM ".cms_db_prefix()."module_notifications_items ORDER BY id DESC";
		$dbresult = $db->Execute($query);

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$obj = new ntfsNotification($full);
			ntfs_handler::Load($obj, $row['id']);	
			
			$result[] = $obj;
		
		}

		return $result;
	}
	
	#---------------------
	# Event methods
	#---------------------  	
	
	public function GetEvents()
	{
		return Events::ListEvents();
	}
	
	public function GetModuleEvents()
	{
		$db = cmsms()->GetDb();

		$result = array();

		$query = "SELECT DISTINCT event_id FROM ".cms_db_prefix()."module_notifications_events";
		$dbresult = $db->Execute($query);

		while ($dbresult && $row = $dbresult->FetchRow()) {

			$result[] = $row['event_id'];		
		}

		return $result;
	}
	
	public function GetEventById($id)
	{
		$events = $this->GetEvents();

		foreach($events as $event) {
		
			if($event['event_id'] == $id) {
			
				return $event;
			}
		}			

		return false;
	}
	
	public function UpdateEventHandlers(ntfsNotification &$obj)
	{	
		$events = $this->GetEvents();
		$mod_events = $this->GetModuleEvents();
		
		// Remove all events that aint neccery for module
		foreach($events as $event) {
		
			if(!in_array($event['event_id'], $mod_events)) {
			
				$this->RemoveEventHandler($event['originator'], $event['event_name']);
			}
		}
		
		// Add new events from object
		foreach($obj->events as $eventid) {
			
			if(in_array($eventid, $mod_events)) { // <- Wtf this shouldn't be working like this, see into it at some point.
			
				$event = $this->GetEventById($eventid);
				$this->AddEventHandler($event['originator'], $event['event_name'], false);
			}
		}
	}
	
	#---------------------
	# Mailer methods
	#---------------------	
	
	public function SendNotification(ntfsNotification $obj, $params)
	{
		$mail = cmsms()->GetModuleInstance('CMSMailer');
		if(!is_object($mail)) {

			die('CMSMailer not installed, please install CMSMailer in order to continue.');
		}
		
		$result = true;
		
		$smarty = cmsms()->GetSmarty();
		$smarty->assign('notification', $obj);
		$smarty->assign('eventparams', $params);

		$subject = $this->ProcessTemplateFromData($obj->subject);
		$body = $this->ProcessTemplateFromData($obj->message_html);
		$altbody = $this->ProcessTemplateFromData($obj->message_plain);

		$mail->AddReplyTo($obj->from_address);
		$mail->SetFrom($obj->from_address);
		$mail->AddAddress($obj->to_address);
		$mail->SetSubject($subject);
		$mail->IsHTML(true);		
		$mail->SetBody($body);
		$mail->SetAltBody($altbody);

		if(!$mail->Send()) {
		
			$result = "Mailer Error: " . $mail->ErrorInfo;
		} 

		$mail->reset();
	
		return $result;

	}	
	
	
} // end of class

?>