<?php
#-------------------------------------------------------------------------
# Module: CGGoogleMaps - A simple module for creating google maps.
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

//
// initialization
//
$defer = 0;
$mapid = '';
$map = '';
$icons = '';

//
// setup
//
if( isset($params['defer']) && $params['defer'] == 1 )
  {
    $defer = 1;
  }

//
// Get the map information
//
$mapid = $this->GetPreference('default_map',0);
$map = '';
if( !isset($params['map']) )
  {
    $params['map'] = (int)$mapid;
  }
if( isset($params['map']) )
  {
    if( is_numeric($params['map']) )
      {
	$map = cggm_map_operations::load_by_id((int)$params['map'],true);
      }
    else
      {
	$map = cggm_map_operations::load_by_name(trim($params['map']),true);
      }
  }
if( !$map )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_invalidparams'));
    return;
  }

//
// add dynamic points.
//
$mid = $map->get_id();
if( is_array($this->_dynamic_points) && isset($this->_dynamic_points[$mid]) && count($this->_dynamic_points[$mid]) )
  {
    for( $i = 0; $i < count($this->_dynamic_points[$mid]); $i++ )
      {
	$map->add_marker($this->_dynamic_points[$mid][$i]);
      }
    unset($this->_dynamic_points[$mid]);
  }

// add kml layers
if( is_array($this->_kml_files) && isset($this->_kml_files[$mid]) && count($this->_kml_files[$mid]) ) {
  for( $i = 0; $i < count($this->_kml_files[$mid]); $i++ ) {
    $map->add_kml($this->_kml_files[$mid][$i]);
  }
  unset($this->_kml_files[$mid]);
}

// add more parameters
if( isset($params['zoomlevel']) )
  {
    $val = min((int)$params['zoomlevel'],17);
    $val = max(1,$val);
    $map->zoom = $val;
  }
if( isset($params['zoom_encompass']) )
  {
    $map->zoom_encompass = ((int)$params['zoom_encompass']);
  }

$generator = new cggm_map_generator($map,$defer);
$output = $generator->generate();
$errors = $generator->get_errors();
if( is_array($errors) )
  {
    echo $this->DisplayErrorMessage(implode('<br/>',$errors));
  }
echo $output;

// EOF
?>
