<?php
if (!isset($gCms)) exit;
if (!$this->HasPermission()) exit;

if (isset($params['id_event']))
{
	$event = new EventsManager_event($params['id_event']);
	
	$registrations = $event->get_registrations();
	$feu_module = cms_utils::get_module('FrontEndUsers');
	
	$pref_displayed_feu_properties = $this->GetPreference('displayed_feu_properties');
	if ($pref_displayed_feu_properties)
		$displayed_feu_properties = explode(',', $pref_displayed_feu_properties);
	else
		$displayed_feu_properties = '';
	
	// Add some FEU informations
	$registrations_smarty = array();
	foreach ($registrations as &$registration)
	{
		$registration_smarty = $registration->get_smarty_object();
		
		$registration_smarty->username = $feu_module->GetUserName($registration->id_user);
		$registration_smarty->feu_props = $feu_module->GetUserProperties($registration->id_user);

		$registration_smarty->deletelink = $this->CreateLink($id, 'admin_deleteregistration', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), array('id_registration'=>$registration->id, 'id_event'=>$registration->id_event), $this->Lang('areyousure'));
		
		$registrations_smarty[] = $registration_smarty;
	}

	$smarty->assign('event', $event);
	$smarty->assign('items', $registrations_smarty);
	$smarty->assign('feu_props_names', $displayed_feu_properties);
	$smarty->assign('feu_props_prompts', $feu_props_prompts);
	$smarty->assign('backlink', $this->CreateLink($id, 'defaultadmin', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/back.gif', $this->Lang('back_toeventslist'), '', '', 'systemicon') .' '.$this->Lang('back_toeventslist')));
	
	$smarty->assign('exportlink', $this->CreateLink($id, 'admin_exportregusers', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/export.gif', $this->Lang('export_regusers'), '24', '29', 'systemicon') . ' ' . $this->Lang('export_regusers'), array('id_event'=>$event->id, 'disable_theme'=>1)));
	
	// Export to NMS link - Only if NMS is installed
	if ($nms_module = cms_utils::get_module('NMS'))
	{
		$smarty->assign('nmsexportlink', $this->CreateLink($id, 'admin_exportregusers_nms', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/export.gif', $this->Lang('export_regusers_nms'), '24', '29', 'systemicon') . ' ' . $this->Lang('export_regusers_nms'), array('id_event'=>$event->id)));
	}
	
	echo $this->ProcessTemplate('admin_viewregusers.tpl');
}

?>