{* adminemail template *}
{* invoice template *}
<h3>{$Orders->Lang('order')}</h3>
<h4>{$Orders->Lang('order_number')}:&nbsp;{$ordernumber}</h4>
<br/>

{if !empty($order.cc_number)}
<h4>{$Orders->Lang('payment_info')}</h4>
<table>
  <tr>
   <td>{$Orders->Lang('creditcard_type')}:</td>
   <td>{$order.cc_type}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('creditcard_number')}:</td>
   <td>{$order.cc_number}</td>
  <tr>
   </td>{$Orders->Lang('creditcard_expiry')}:</td>
   <td>{$order.cc_expiry|cms_date_format}</td>
  </tr>
  <tr>
   </td>{$Orders->Lang('creditcard_verifycode')}:</td>
   <td>{$order.cc_verifycode}</td>
  </tr>
</table>
<br/>
{/if}

<h4>{$Orders->Lang('bill_to')}</h4>
<table>
  <tr>
   <td>{$Orders->Lang('first_name')}:</td>
   <td>{$order.billing_first_name}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('last_name')}:</td>
   <td>{$order.billing_last_name}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('address1')}:</td>
   <td>{$order.billing_address1}</td>
  </tr>
  {if !empty($order.billing_address2)}
  <tr>
   <td>{$Orders->Lang('address2')}:</td>
   <td>{$order.billing_address2}</td>
  </tr>
  {/if}
  <tr>
   <td>{$Orders->Lang('city')}:</td>
   <td>{$order.billing_city}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('state/province')}:</td>
   <td>{$order.billing_state}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('postal')}:</td>
   <td>{$order.billing_postal}</td>
  </tr>
  <tr>
   <td>{$Orders->Lang('country')}:</td>
   <td>{$order.billing_country}</td>
  </tr>
  {if !empty($order.billing_phone)}
  <tr>
   <td>{$Orders->Lang('phone')}:</td>
   <td>{$order.billing_phone}</td>
  </tr>
  {/if}
  {if !empty($order.billing_fax)}
  <tr>
   <td>{$Orders->Lang('fax')}:</td>
   <td>{$order.billing_fax}</td>
  </tr>
  {/if}
  {if !empty($order.billing_email)}
  <tr>
   <td>{$Orders->Lang('email_address')}:</td>
   <td>{$order.billing_email}</td>
  </tr>
  {/if}
</table>
<br/>

{if !empty($order.order_notes)}
<h4>{$Orders->Lang('special_instructions')}</h4>
{$order.order_notes}<br/>
<br/>
{/if}

{foreach from=$order.shipping item='shipping'}
<h4>{$Orders->Lang('ship_to')}: {$shipping.shipping_last_name}, {$shipping.shipping_first_name}</h4>
  <p>  
    {$shipping.shipping_address1}<br/>
    {if !empty($shipping.shipping_address2)}{$shipping.shipping_address2}<br/>{/if}
    {$shipping.shipping_city}, {$shipping.shipping_state}<br/>
    {$shipping.shipping_country}<br/>
    {$shipping.shipping_postal}<br/>
    {if !empty($shipping.shipping_phone)}{$Orders->Lang('phone')}:&nbsp;{$shipping.shipping_phone}<br/>{/if}
    {if !empty($shipping.shipping_fax)}{$Orders->Lang('fax')}:&nbsp;{$shipping.shipping_fax}<br/>{/if}
    {if !empty($shipping.shipping_email)}{$Orders->Lang('email_address')}:&nbsp;{$shipping.shipping_email}<br/>{/if}
  </p>
  <p><strong>&nbsp;{$Orders->Lang('items')}:</strong></p>
  <table align="center" border="1" width="100%">
    <thead>
      <tr>
        <th>{$Orders->Lang('num')}</th>
        <th>{$Orders->Lang('product_id')}</th>
        <th>{$Orders->Lang('description')}</th>
        <th>{$Orders->Lang('unit_weight')}</th>
        <th>{$Orders->Lang('unit_price')}</th>
        <th>{$Orders->Lang('quantity')}</th>
        <th>{$Orders->Lang('total')}</th>
      </tr>
    </thead>
    <tbody>
    {foreach from=$shipping.items item='item' name='items'}
      <tr>
        <td>{$smarty.foreach.items.index}</td>
        <td>{$item.item_id}</td>
        <td>{$item.product_name}</td>
        <td>{$item.weight|number_format:2}{$weightunits}</td>
        <td>{$currencysymbol}{$item.price|number_format:2}</td>
        <td>{$item.quantity}</td>
        <td>{$currencysymbol}{math equation='x * y' x=$item.quantity y=$item.price assign='tmp'}{$tmp|number_format:2}</td>
      </tr>
    {/foreach}
    <tr>
      <td colspan="6" align="right">{$Orders->Lang('subtotal')}</td>
      <td align="right">{$currencysymbol}{$order.subtotal|number_format:2}</td>
    </tr>
    <tr>
      <td colspan="6" align="right">{$Orders->Lang('tax')}</td>
      <td align="right">{$currencysymbol}{$order.tax|number_format:2}</td>
    </tr>
    <tr>
      <td colspan="6" align="right">{$Orders->Lang('shipping')}</td>
      <td align="right">{$currencysymbol}{$order.shipping_cost|number_format:2}</td>
    </tr>
    <tr>
      <td colspan="6" align="right">{$Orders->Lang('total')}</td>
      <td align="right">{$currencysymbol}{$order.total|number_format:2}</td>
    </tr>
    </tbody>
  </table>
</table>
<br/>
{/foreach}
<br/>

<h4>{$Orders->Lang('order_summary')}</h4>
<table align="center" border="1" width="100%">
  <tr>
    <td width="80%" align="right">{$Orders->Lang('subtotal')}</td>
    <td align="right">{$currencysymbol}{$order.subtotal|number_format:2}</td>
  </tr>
  <tr>
    <td width="80%" align="right">{$Orders->Lang('tax')}</td>
    <td align="right">{$currencysymbol}{$order.tax|number_format:2}</td>
  </tr>
  <tr>
    <td width="80%" align="right">{$Orders->Lang('shipping')}</td>
    <td align="right">{$currencysymbol}{$order.shipping_total|number_format:2}</td>
  </tr>
  <tr>
    <td width="80%" align="right">{$Orders->Lang('total')}</td>
    <td align="right">{$currencysymbol}{$order.total|number_format:2}</td>
  </tr>
</table>
