<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_order
{
  private $_id;
  private $_feu_user;
  private $_invoice;
  private $_billing;
  private $_status;
  private $_order_notes;
  private $_create_date;
  private $_modified_date;
  private $_shipping_recs;
  private $_payment_recs;
  private $_note_recs;


  public function get_id()
  {
    return $this->_id;
  }


  public function set_id($val,$set_invoice = false)
  {
    $this->_id = $val;
    if( $set_invoice )
      {
	$this->set_invoice(orders_helper::make_invoice_number($this->get_id()));
      }
  }


  public function get_invoice()
  {
    return $this->_invoice;
  }


  public function set_invoice($val)
  {
    $this->_invoice = $val;
  }


  public function get_feu_user()
  {
    return $this->_feu_user;
  }


  public function set_feu_user($val)
  {
    $this->_feu_user = $val;
  }


  public function get_billing()
  {
    return $this->_billing;
  }


  public function set_billing($val)
  {
    $this->_billing = $val;
  }


  public function get_status()
  {
    return $this->_status;
  }


  public function set_status($val)
  {
    $this->_status = $val;
  }

  
  public function get_order_notes()
  {
    return $this->_order_notes;
  }


  public function set_order_notes($val)
  {
    $this->_order_notes = $val;
  }


  public function get_create_date()
  {
    return $this->_create_date;
  }


  public function set_create_date($val)
  {
    $this->_create_date = $val;
  }


  public function get_modified_date()
  {
    return $this->_modified_date;
  }


  public function set_modified_date($val)
  {
    $this->_modified_date = $val;
  }


  public function add_shipping(orders_shipping &$shipping,$reset_id = true)
  {
    if( $reset_id )
      {
	$shipping->set_id(null);
      }
    $shipping->set_order_id($this->get_id());
    if( !is_array($this->_shipping_recs) )
      {
	$this->_shipping_recs = array();
      }
    $this->_shipping_recs[] = $shipping;
  }


  public function del_shipping($idx)
  {
    $new_data = array();
    for( $i = 0; $i < count($this->_shipping_recs); $i++ )
      {
	if( $i != $idx )
	  {
	    $new_data[] = $this->_shipping_recs[$i];
	  }
      }
    $this->_shipping_recs = $new_data;
  }


  public function &get_shipping($idx)
  {
    if( $idx >= 0 && $idx < count($this->_shipping_recs) )
      {
	return $this->_shipping_recs[$idx];
      }
  }


  public function get_destinations()
  {
    return $this->_shipping_recs;
  }


  public function count_destinations()
  {
    return count($this->_shipping_recs);
  }


  public function count_real_items()
  {
    $itemcount = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$itemcount += $shipping->count_real_items();
      }
    return $itemcount;
  }


  public function add_payment(orders_payment &$payment,$reset_id = true)
  {
    if( $reset_id )
      {
	$payment->set_id(null);
      }
    $payment->set_order_id($this->get_id());
    if( !is_array($this->_payment_recs) )
      {
	$this->_payment_recs = array();
      }
    $this->_payment_recs[] = $payment;
  }


  public function count_payments()
  {
    return count($this->_payment_recs);
  }


  public function &get_payments()
  {
    return $this->_payment_recs;
  }


  public function &get_payment($idx)
  {
    if( $idx >= 0 && $idx < count($this->_payment_recs) )
      {
	return $this->_payment_recs[$idx];
      }
  }


  public function &get_payment_by_id($pmt_id)
  {
    $res = null;
    for( $i = 0; $i < count($this->_payment_recs); $i++ )
      {
	if( $this->_payment_recs[$i]->get_id() == $pmt_id )
	  {
	    $res =& $this->_payment_recs[$i];
	  }
      }
    return $res;
  }


  public function &get_payment_by_txn_id($txn_id)
  {
    $res = null;
    for( $i = 0; $i < count($this->_payment_recs); $i++ )
      {
	if( $this->_payment_recs[$i]->get_txn_id() == $txn_id )
	  {
	    $res =& $this->_payment_recs[$i];
	  }
      }
    return $res;
  }


  public function add_note(orders_message &$message,$reset_id = true)
  {
    if( $reset_id )
      {
	$message->set_id(null);
      }
    $message->set_order_id($this->get_id());
    if( !is_array($this->_note_recs) )
      {
	$this->_note_recs = array();
      }
    $this->_note_recs[] = $message;
  }


  public function count_notes()
  {
    return count($this->_note_recs);
  }


  public function &get_notes()
  {
    return $this->_note_recs;
  }


  public function &get_note($idx)
  {
    if( $idx >= 0 && $idx < count($this->_note_recs) )
      {
	return $this->_note_recs[$idx];
      }
  }


  public function get_note_by_id($note_id)
  {
    for( $i = 0; $i < count($this->_note_recs); $i++ )
      {
	if( $this->_note_recs[$i]->get_id() == $note_id )
	  {
	    return $this->_note_recs[$i];
	  }
      }
  }


  public function get_weight()
  {
    $weight = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$weight += $shipping->get_weight();
      }
    return $weight;
  }


  public function get_subtotal()
  {
    $subtotal = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$subtotal += $shipping->get_subtotal();
      }
    return $subtotal;
  }


  public function get_shipping_cost()
  {
    $shipping_cost = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$shipping_cost += $shipping->get_shipping_cost();
      }
    return $shipping_cost;
  }


  public function get_tax_cost()
  {
    $tax_cost = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$tax_cost += $shipping->get_tax_cost();
      }
    return $tax_cost;
  }


  public function get_discount()
  {
    $discount = 0;
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$discount += $shipping->get_discount();
      }
    return $discount;
  }


  public function get_total()
  {
    return $this->get_subtotal() + $this->get_shipping_cost() +
      $this->get_tax_cost() + $this->get_discount();
  }


  public function get_amount_paid()
  {
    $sum = 0;
    for( $i = 0; $i < $this->count_payments(); $i++ )
      {
	$payment =& $this->_payment_recs[$i];
	if( $payment->get_status() != orders_payment::STATUS_APPROVED )
	  continue;
	$sum += $payment->get_amount();
      }
    return $sum;
  }


  public function get_amount_due()
  {
    return $this->get_total() - $this->get_amount_paid();
  }


  public function save($del_children = false)
  {
    if( $this->get_id() > 0 )
      {
	return orders_ops::update($this,$del_children);
      }
    return orders_ops::insert($this);
  }


  public function is_all_shipped()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( !$shipping->is_all_shipped() ) return FALSE;
      }
    return TRUE;
  }


  public function is_partially_shipped()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( !$shipping->is_partially_shipped() ) return FALSE;
      }
    return TRUE;
  }


  public function has_services()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( $shipping->has_services() ) return TRUE;
      }
    return FALSE;
  }


  public function is_service_only()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( !$shipping->is_service_only() ) return FALSE;
      }
    return TRUE;
  }


  public function has_subscriptions()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( $shipping->has_subscriptions() ) return TRUE;
      }
    return FALSE;
  }


  public function is_subscription_only()
  {
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	if( !$shipping->is_subscription_only() ) return FALSE;
      }
    return TRUE;
  }


  public function from_array($data,$prefix='billing_')
  {
    $this->set_id($data['id']);
    $this->set_feu_user($data['feu_user_id']);
    $this->set_invoice($data['invoice']);
    $this->set_status($data['status']);
    $this->set_order_notes($data['order_notes']);
    $this->set_create_date($data['create_date']);
    $this->set_modified_date($data['modified_date']);

    $addr = new orders_address();
    $addr->from_array($data,$prefix);
    $this->set_billing($addr);
  }


  public function to_array()
  {
    $result = array();
    $result['id'] = $this->get_id();
    $result['feu_user_id'] = $this->get_feu_user();
    $result['invoice'] = $this->get_invoice();
    $result['status'] = $this->get_status();
    $result['order_notes'] = $this->get_order_notes();
    $result['create_date'] = $this->get_create_date();
    $result['modified_date'] = $this->get_modified_date();

    $billing_addr = $this->get_billing();
    $tmp = $billing_addr->to_array('billing_');
    $result = array_merge($tmp,$result);

    $result['shipping'] = array();
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping = $this->get_shipping($i);
	$result['shipping'][] = $shipping->to_array();
      }

    $result['payments'] = array();
    for( $i = 0; $i < $this->count_payments(); $i++ )
      {
	$payment = $this->get_payment($i);
	$result['payments'][] = $payment->to_array();
      }

    // for backward compatibilty... remove me soon.
    $result['subtotal'] = $this->get_subtotal();
    $result['tax'] = $this->get_tax_cost();
    $result['shipping_total'] = $this->get_shipping_cost();
    $result['total'] = $this->get_total();
    return $result;
  }


  public function reset_ids()
  {
    $this->set_id(null);
    for( $i = 0; $i < $this->count_destinations(); $i++ )
      {
	$shipping =& $this->get_shipping($i);
	$shipping->reset_ids();
      }
  }


} // end of class

// EOF
?>