{$formstart}
<fieldset>
  <legend>{$Orders->Lang('filter')}:&nbsp;</legend>
<table width="100%">
  <tr>
  <td valign="top">
    <div class="pageoverflow">
       <p class="pagetext">{$Orders->Lang('status')}:</p>
       <p class="pageinput">{$order_status_dropdown}</p>
    </div>
    <div class="pageoverflow">
       <p class="pagetext">{$Orders->Lang('prompt_date_search_type')}:</p>
       <p class="pageinput">{$datelimit_type_dropdown} {$Orders->Lang('within')} {$datelimit_interval_dropdown}</p>
    </div>
    <div class="pageoverflow">
       <p class="pagetext">{$Orders->Lang('prompt_pagelimit')}:</p>
       <p class="pageinput">
         <select name="{$actionid}pagelimit">
           {html_options options=$pagelimits selected=$val_pagelimit}
         </select>
       </p>
    </div>
  </td>
  <td valign="top">
    <div class="pageoverflow">
       <p class="pagetext">{$Orders->Lang('order_number')}:</p>
       <p class="pageinput">{$order_number} <em>{$Orders->lang('info_use_integer')}</em></p>
    </div>
    <div class="pageoverflow">
       <p class="pagetext">{$Orders->Lang('item_string')}:</p>
       <p class="pageinput">
          <input type="text" name="{$actionid}item_string" value="{$item_string}" size="40" maxlength="255"/>
          <br/> 
          {$Orders->Lang('info_item_string')}
       </p>
    </div>
  </td>
  </tr>
</table>
  <div class="pageoverflow">
     <p class="pagetext">&nbsp;</p>
     <p class="pageinput">{$submit}</p>
  </div>
</fieldset>
<br />
{$formend}

{if isset($orders) && count($orders)}
{if isset($export_link)}
<div class="pageoptions">
{$export_link}
</div>
{/if}

<div class="pageoverflow">
   <div style="float: left; width: 24%;">{$Orders->Lang('records_matching_query')}:&nbsp;{$recordcount}</div>
   <div style="float: left; width: 50%; text-align: center;">
     {if isset($prevpage_url)}
       <a href="{$firstpage_url}" title="{$Orders->Lang('title_first_page')}">{$Orders->Lang('firstpage')}</a>&nbsp;
       <a href="{$prevpage_url}" title="{$Orders->Lang('title_prev_page')}">{$Orders->Lang('prevpage')}</a>&nbsp;
     {/if}
     {$Orders->Lang('prompt_page')}&nbsp;{$pagenum}&nbsp;{$Orders->Lang('prompt_of')}&nbsp;{$pagecount}
     {if isset($nextpage_url)}
       &nbsp;<a href="{$nextpage_url}" title="{$Orders->Lang('title_next_page')}">{$Orders->Lang('nextpage')}</a>
       &nbsp;<a href="{$lastpage_url}" title="{$Orders->Lang('title_last_page')}">{$Orders->Lang('lastpage')}</a>
     {/if}
   </div>
   <div style="float: right; width: 24%;">&nbsp;</div>
</div>
<table cellspacing="0" class="pagetable cms_sortable tablesorter">
  <thead>
    <tr>
	<th>{$Orders->Lang('order_number')}</th>
	<th>{$Orders->Lang('customer_name')}</th>
	<th>{$Orders->Lang('status')}</th>
	<th>{$Orders->Lang('items')}</th>
	<th>{$Orders->Lang('created')}</th>
	<th>{$Orders->Lang('modified')}</th>
	<th>{$Orders->Lang('total')}</th>
	<th>{$Orders->Lang('amt_due')}</th>
	<th class="pageicon {literal}{sorter: false}{/literal}">&nbsp;</th>
        {if isset($allowdelete)}
	<th class="pageicon {literal}{sorter: false}{/literal}">&nbsp;</th>
        {/if}
    </tr>
  </thead>
  <tbody>
  {foreach from=$orders item='order'}
    <tr>
      <td>{capture assign='tmp'}{$order.ordernum}{/capture}{module_action_link module='Orders' action='admin_manageorder' orderid=$order.id text=$tmp}</td>
      <td>{$order.billing_first_name} {$order.billing_last_name}</td>
      <td>{$Orders->Lang($order.status)}</td>
      <td>{$order.items}</td>
      <td>{$order.create_date|cms_date_format}</td>
      <td>{$order.modified_date|cms_date_format}</td>
      <td>{$currencysymbol}{$order.total|number_format:2}</td>
      <td>
        {if $order.amt_due < -0.01}
          <span style="color: red;">{$currencysymbol}{$order.amt_due|number_format:2}</span>
        {else}
        {$currencysymbol}{$order.amt_due|number_format:2}
        {/if}
      </td>
      <td>{module_action_link module='Orders' action='admin_manageorder' text=$tmp image='icons/system/view.gif' imageonly=1 orderid=$order.id}</td>
      {if isset($order.delete_link)}
      <td>{$order.delete_link}</td>
      {/if}
    </tr>
  {/foreach}
  </tbody>
</table>
{/if}
