<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple example frontend form module
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_gateway_helper
{
  static public function process_gateway_transaction(cgpgb_async_transaction& $trans)
  {
    global $gCms;
    $db = $gCms->GetDb();
    $orders_mod = cge_utils::get_module('Orders');

    $order_id = $trans->get_order_id();
    if( !$order_id ) 
      return $orders_mod->Lang('error_orderinvalid');
    $order_obj = orders_ops::load_by_id($order_id);
    if( !is_object($order_obj) ) return $this->Lang('error_orderinvalid');

    $uid = $trans->get_user_id();
    $transaction_id = $trans->get_id();
    $amount = $trans->get_amount();
    $payment_id = $trans->get_payment_id();

    if( $uid && $order_obj->get_feu_user() != $uid )
      {
	return $orders_mod->Lang('error_orderinvalid');
      }

    $billing = $order_obj->get_billing();
    $email_addr = $billing->get_email();
    if( !$email_addr ) 
      return $orders_mod->Lang('error_noemailaddress');

    //
    // try to find a payment that matches
    //
    $payment = $order_obj->get_payment_by_txn_id($transaction_id);
    if( !$payment )
      {
	// so payment found, try to find one by it's id.
	if( $payment_id > 0 )
	  {
	    $payment = $order_obj->get_payment_by_id($payment_id);
	  }

	if( !$payment )
	  {
	    // still no payment found, this could mean that
	    // the gateway required credit card information but we're not storing it
	    // in which case we gotta create a new payment object.
	    $payment = new orders_payment();
	    $payment->set_payment_date(cge_utils::db_time(time()));
	    $payment->set_order_id($order_id);
	    $order_obj->add_payment($payment);
	  }
      }

    // and update it from the transaction.
    $payment->set_txn_id($transaction_id);
    $payment->set_method(orders_payment::TYPE_ONLINE);
    $payment->set_gateway($trans->get_gateway());
    $payment->set_amount($amount);
    // add extra data to the payment.
    $tmp_keys = $trans->get_other_keys();
    if( $tmp_keys )
      {
	foreach( $tmp_keys as $tmp_key )
	  {
	    $payment->set_extra($tmp_key,$trans->get_other_val($tmp_key));
	  }
      }

    // Update the payment status
    $message = $trans->get_message();
    $retstatus = '';
    $status = $trans->get_status();
    $do_orderstatus = TRUE;
    switch( $status )
      {
      case PAYMENT_STATUS_NONE:
	$do_orderstatus = FALSE;
	return;

      case PAYMENT_STATUS_APPROVED:
	{
	  $payment->set_status(orders_payment::STATUS_APPROVED);
	  $orders_mod->Audit($order_id,$orders_mod->GetName(),sprintf("%.2f received for order %d (transaction id: %s)",$amount,$order_id,$transaction_id));
	}
	break;

      case PAYMENT_STATUS_ERROR:
	{
	  // bad address or something
	  $payment->set_status(orders_payment::STATUS_ERROR);
	  if( !empty($message) ) 
	    {
	      $retstatus = $message;
	    }
	  else
	    {
	      $retstatus = $orders_mod->Lang('error_orderprocessing');
	    }

	  $orders_mod->Audit($order_id,$orders_mod->GetName(),sprintf('Error occurred with payment for order %s (transaction id: %s)',$order_id,$transaction_id));
	}
	break;

      case PAYMENT_STATUS_OTHER:
	{
	  // bad address or something
	  $payment->set_status(orders_payment::STATUS_OTHER);
	  if( !empty($message) ) 
	    {
	      $retstatus = $message;
	    }
	  else
	    {
	      $retstatus = $orders_mod->Lang('error_orderprocessing');
	    }

	  $orders_mod->Audit($order_id,$orders_mod->GetName(),$orders_mod->Lang('msg_payment_error',$transaction_id,$order_id));
	}
	break;

      case PAYMENT_STATUS_PENDING:
	{
	  // the gateway stuff worked, but we haven't had
	  // final approval for the purchase yet.
	  $cur_status = $order_obj->get_status();
	  if( $cur_status == ORDERSTATUS_PROPOSED  || $cur_status == ORDERSTATUS_PENDING ||
	      $cur_status == ORDERSTATUS_CONFIRMED)
	    {
	      $payment->set_status(orders_payment::STATUS_PENDING);
	      $orders_mod->Audit($order_id,$orders_mod->GetName(),$orders_mod->Lang('msg_payment_pending',$order_id));
	    }
	  else
	    {
	      // maybe the async stuff came in BEFORE we got here synchronously
	      $orders_mod->Audit($order_id,$orders_mod->GetName(),$orders_mod->Lang('msg_payment_setbackwards',$order_id));
	      $retstatus = $orders_mod->Lang('msg_payment_setbackwards',$order_id);
	      $do_orderstatus = FALSE;
	    }
	}
	break;

      case PAYMENT_STATUS_DECLINED:
	{
	  $payment->set_status(orders_payment::STATUS_DECLINED);
	  $orders_mod->Audit($order_id,$orders_mod->GetName(),$orders_mod->Lang('msg_payment_declined',$transaction_id,$order_id));
	}
	break;

      case PAYMENT_STATUS_CANCELLED:
	{
	  $payment->set_status(orders_payment::STATUS_CANCELLED);
	  $orders_mod->Audit($order_id,$orders_mod->GetName(),$orders_mod->Lang('msg_payment_cancelled',$transaction_id,$order_id));
	}
	break;

      default:
	$retstatus = $orders_mod->Lang('error_unknownstatus');
	break;
      }

    // oops, we got an error.
    if( $retstatus )
      {
	return $retstatus;
      }

    if( $do_orderstatus )
      {
	// figure out what the order status should be.
	// there prolly should be some preferences to help in decision making.
	$all_shipped  = $order_obj->is_all_shipped();
	$part_shipped = $order_obj->is_partially_shipped();
	$none_shipped = (!$all_shipped && !$part_shipped)?TRUE:FALSE;
	$all_paid     = ($order_obj->get_amount_due() > 0.01)?FALSE:TRUE;
	$cur_status   = $order_obj->get_status();
	$has_services = $order_obj->has_services();
	$subscr_only  = $order_obj->is_subscription_only();
	$service_only = $order_obj->is_service_only();
	switch( $cur_status )
	  {
	    // finished checking out... we can adjust it
	  case ORDERSTATUS_PROPOSED:
	  case ORDERSTATUS_CONFIRMED:
	  case ORDERSTATUS_PENDING:
	    // statuses set automagically.. we can adjust it.
	  case ORDERSTATUS_PAID:
	  case ORDERSTATUS_BALANCEDUE:
	  case ORDERSTATUS_INCOMPLETE:
	    if( $status == PAYMENT_STATUS_CANCELLED )
	      {
		$order_obj->set_status(ORDERSTATUS_CANCELLED);
	      }
	    else if( $status == PAYMENT_STATUS_PENDING )
	      {
		$order_obj->set_status(ORDERSTATUS_PENDING);
	      }
	    else if( !$all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_BALANCEDUE);
	      }
	    else if( !$has_services )
	      {
		// only products
		if( $all_shipped )
		  {
		    $order_obj->set_status(ORDERSTATUS_COMPLETE);
		  }
		else if( $part_shipped )
		  {
		    $order_obj->set_status(ORDERSTATUS_INCOMPLETE);
		  }
		else
		  {
		    $order_obj->set_status(ORDERSTATUS_PAID);
		  }
	      }
	    else if( $subscr_only )
	      {
		$order_obj->set_status(ORDERSTATUS_SUBSCRIBED);
	      }
	    break;
	
	    // user was invoiced... why are we even getting here?
	  case ORDERSTATUS_INVOICED:
	    // completed already, shouldn't even get here.
	  case ORDERSTATUS_COMPLETED:
	  case ORDERSTATUS_SUBSCRIBED:
	    // admin set statuses... don't adjust.
	  case ORDERSTATUS_CANCELLED:
	  case ORDERSTATUS_HOLD:
	  default:
	    break;
	  }

	$orders_mod->Audit($order_id,$orders_mod->GetName(),'Order status set to '.$orders_mod->Lang($order_obj->get_status()));

	// save the order
	$order_obj->save();
      }


    //
    // we're done with processing the order.
    // maybe we need to send an email.
    // actually, we could use a different template for each status... but we won't for now.
    //
    $sendemail = false;
    switch($order_obj->get_status())
      {
      case ORDERSTATUS_COMPLETED:
      case ORDERSTATUS_PAID:
      case ORDERSTATUS_INVOICED:
      case ORDERSTATUS_CONFIRMED:
      case ORDERSTATUS_SUBSCRIBED:
	$sendemail = true;
	break;
      }

    if( !$sendemail )
      {
	// we're done.
	return;
      }

    // update smarty.
    $smarty = $gCms->GetSmarty();
    $smarty->assign('transaction_id',$transaction_id);
    $smarty->assign('orders',$orders_mod);
    $smarty->assign('message',$message);
    $smarty->assign('gateway_status',$status);
    $smarty->assign('email_address',$email_addr);
    $smarty->assign('order',$order_obj->to_array()); // deprecated.
    $smarty->assign('order_obj',$order_obj);
    $smarty->assign('ordernumber',$order_obj->get_invoice()); // deprecated.
    if( $status == PAYMENT_STATUS_APPROVED )
      {
	$smarty->assign('status','SUCCESS');
      }
    else if ($status == PAYMENT_STATUS_PENDING )
      {
	$smarty->assign('status','PENDING');
      }

    // send it if we need to.
    if( $sendemail )
      {
	$cmsmailer = cge_utils::get_module('CMSMailer');

	// Send an email to the administrator
	$addresses = explode(',',$orders_mod->GetPreference('admin_email'));
	if( is_array($addresses) && count($addresses) > 0 )
	{
	  $subject = $orders_mod->ProcessTemplateFromData($orders_mod->GetPreference('adminemail_subject'));
	  $body = $orders_mod->ProcessTemplateFromDatabase('adminemail_template');
	  $n = 0;
	  foreach( $addresses as $addr )
	    {
	      $addr = trim($addr); 
	      if( !$addr ) continue;
	      $cmsmailer->AddAddress($addr);
	      $n++;
	    }
	  if( $n )
	    {
	      $cmsmailer->SetSubject($subject);
	      $cmsmailer->SetBody($body);
	      $cmsmailer->IsHTML(true);
	      $cmsmailer->Send();
	      $cmsmailer->reset();
	    }
	}

	// Send an email to the user
	{
	  $subject = $orders_mod->ProcessTemplateFromData($orders_mod->GetPreference('useremail_subject'));
	  $body = $orders_mod->ProcessTemplateFromDatabase('useremail_template');
	  $cmsmailer->AddAddress($email_addr);
	  $cmsmailer->SetSubject($subject);
	  $cmsmailer->SetBody($body);
	  $cmsmailer->IsHTML(true);
	  $cmsmailer->Send();
	  $cmsmailer->reset();
	}
      }

    // and we're done.
    return;    
    
  } // function
} // end of class.

#
# EOF
#
?>
