<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple example frontend form module
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

// this should go into the orders_order class.
define('ORDERSTATUS_PROPOSED','proposed');      // customer has placed order, but not confirmed it yet
define('ORDERSTATUS_PENDING','pending');        // this order has been submitted for payment, but not yet approved.
define('ORDERSTATUS_CONFIRMED','confirmed');    // customer has confirmed order, but not processed payment

define('ORDERSTATUS_SUBMITTED','submitted');    // delete me?
define('ORDERSTATUS_INVOICED','invoiced');      // customer has completed manual invoice process
define('ORDERSTATUS_CANCELLED','cancelled');    // this order has been cancelled (by an admin, or by the user)
define('ORDERSTATUS_PAID','paid');              // this order is paid in full
define('ORDERSTATUS_HOLD','hold');              // this order is on hold
define('ORDERSTATUS_BALANCEDUE','balancedue');  // this order has not been paid in full
define('ORDERSTATUS_INCOMPLETE','incomplete');  // not all items for this order have been shipped
define('ORDERSTATUS_COMPLETED','completed');    // this order has been paid in full, and shipped in full.
define('ORDERSTATUS_SUBSCRIBED','subscribed');  // this order is a subscription only order, and is active.

define('ITEMSTATUS_PENDING','pending');         // this service item has not been delivered
define('ITEMSTATUS_DELIVERED','delivered');     // this service item has been delivered
define('ITEMSTATUS_BACKORDER','backorder');     // this order item is on backorder
define('ITEMSTATUS_SHIPPED','shipped');         // this order item has been shipped
define('ITEMSTATUS_NOTSHIPPED','notshipped');   // this order item has not been shppped
define('ITEMSTATUS_HOLD','hold');               // this order item is on hold

define('ORDERS_PERM_VIEWORDERS','View Orders');
define('ORDERS_PERM_MANAGEORDERS','Manage Orders');
define('ORDERS_PERM_CONTACT_CUSTOMERS','Contact Customers');
define('ORDERS_PERM_DELETE_ORDERS','Delete Orders');

$cgecommbase = cms_join_path($gCms->config['root_path'],'modules',
			      'CGEcommerceBase','CGEcommerceBase.module.php');
if( !is_readable( $cgecommbase ) )
{
  echo '<h1><font color="red">ERROR: The CGEcommerceBase module could not be found.</font></h1>';
  return;
}
require_once($cgecommbase);

class Orders extends CGEcommerceBase
{

  public function __construct()
  {
    parent::__construct();
    $this->AddImageDir('icons');
  }

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'Orders';
  }

  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.13.1';
  }


  /*---------------------------------------------------------
   AllowAutoInstall()
   ---------------------------------------------------------*/
  function AllowAutoInstall()
  {
    return FALSE;
  }


  /*---------------------------------------------------------
   AllowAutoUpgrade()
   ---------------------------------------------------------*/
  function AllowAutoUpgrade()
  {
    return FALSE;
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return @file_get_contents(dirname(__FILE__).'/changelog.html.inc');
  }
  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'ecommerce';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission(ORDERS_PERM_VIEWORDERS) ||
      $this->CheckPermission(ORDERS_PERM_MANAGEORDERS) ||
      $this->CheckPermission(ORDERS_PERM_CONTACT_CUSTOMERS);
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGEcommerceBase'=>'1.2.4',
		 'FrontEndUsers'=>'1.12.8',
		 'CGExtensions'=>'1.24',
		 'CGSimpleSmarty'=>'1.3.1',
		 'CMSMailer'=>'1.73.13',
		 'CGPaymentGatewayBase'=>'1.0.10');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.9.4";
  }
	
	
  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    encrypted_store::set_timeout($this->GetPreference('datastore_timeout',10)*60);

    $this->AddImageDir('icons');
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->SetParameterType('order_notes',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/orders_.*/',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/billing_.*/',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/shipping_.*/',CLEAN_STRING);
    $this->SetParameterType('submit',CLEAN_STRING);
    $this->SetParameterType('submit_x',CLEAN_INT);
    $this->SetParameterType('submit_y',CLEAN_INT);
    $this->SetParameterType('gateway',CLEAN_STRING);
    $this->SetParameterType('confirmation_code',CLEAN_STRING);
    $this->SetParameterType('order_id',CLEAN_INT);
    $this->SetParameterType('datakey',CLEAN_STRING);
    $this->SetParameterType('invoice_prefix',CLEAN_STRING);

    $this->CreateParameter('invoice_prefix','',$this->Lang('help_param_invoice_prefix'));
    $this->CreateParameter('template','',$this->Lang('help_param_template'));
    $this->SetParameterType('template',CLEAN_STRING);

//     $this->CreateParameter('nocaptcha','',$this->Lang('help_param_nocaptcha'));
//     $this->SetParameterType('nocaptcha',CLEAN_INT);
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	


  /*---------------------------------------------------------
   GetHeaderHTML()
   ---------------------------------------------------------*/
  function GetHeaderHTML()
  {
    global $gCms;
    $config = $gCms->GetConfig();
    $output = '';

    $url = $config['root_url'].'/modules/'.$this->GetName().'/admin.css';
    $url2 = $config['root_url'].'/modules/'.$this->GetName().'/admin_print.css';
    $str = '';
    $str .= '<link rel="stylesheet" type="text/css" href="'.$url.'" />';
    $str .= '<link rel="stylesheet" type="text/css" href="'.$url2.'" media="print" />';
    $output = $str;

    $obj =& $this->GetModuleInstance('JQueryTools');
    if( is_object($obj) )
      {
$tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
        $output .= "\n".$this->ProcessTemplateFromData($tmpl);
      }

    return $output;
  }	


  /*---------------------------------------------------------
   HandlesEvents();
   ---------------------------------------------------------*/
  function HandlesEvents()
  {
    return TRUE;
  }


  function SuppressAdminOutput(&$request)
  {
    if( isset($request['suppress_output']) ) return TRUE;

    $ret = FALSE;
    foreach( $request as $key => $value )
      {
	if( endswith($key,'showtemplate') && 
	    ($value == FALSE || $value == 'false') )
	  {
	    $ret = TRUE;
	    break;
	  }
      }
    return $ret;
  }


  /*---------------------------------------------------------
   GetEventHelp()
   ---------------------------------------------------------*/
  function GetEventHelp($event_name)
  {
    return $this->Lang('event_help_'.$event_name);
  }	


  /*---------------------------------------------------------
   GetEventDescription()
   ---------------------------------------------------------*/
  function GetEventDescription($event_name)
  {
    return $this->Lang('event_desc_'.$event_name);
  }	


  function GetUsername($uid)
  {
    $feu =& $this->GetModuleInstance('FrontEndUsers');
    return $feu->GetUsername($uid);
  }


  public function _getRealEncryptionKey()
  {
    global $gCms;
    $config = $gCms->GetConfig();
    $key = $this->GetPreference('encryption_key');
    if( empty( $key ) ) return '';
    $key = md5($config['root_path'].' '.$key);
    $key = substr($key,0,16);
    return $key;
  }


  static public function &GetOrder($order_id)
  {
    //require_once(dirname(__FILE__).'/lib/class.orders_ops.php');
    return orders_ops::load_by_id($order_id);
  }


  static public function get_portable_order($order_id)
  {
    $tmp = orders_ops::load_by_id($order_id);
    if( is_object($tmp) )
      {
	return $tmp->to_array();
      }
  }


  protected function get_country_list()
  {
    $tmp = $this->GetPreference('valid_countries','');
    if( !$tmp )
      {
        return parent::get_country_list();
      }
    
    $tmp2 = explode("\n",$tmp);
    $tmp3 = array();
    foreach( $tmp2 as $one )
      {
        if( strstr($one,'=') === FALSE ) continue;
        $one = trim($one);
        list($code,$name) = explode('=',$one,2);
        $tmp3[] = array('name' => $name, 'code' => strtoupper($code));
      }
    return $tmp3;
  }


  protected function get_state_list()
  {
    $tmp = $this->GetPreference('valid_states','');
    if( !$tmp )
      {
        return parent::get_state_list();
      }
    
    $tmp2 = explode("\n",$tmp);
    $tmp3 = array();
    foreach( $tmp2 as $one )
      {
        if( strstr($one,'=') === FALSE ) continue;
        $one = trim($one);
        list($code,$name) = explode('=',$one,2);
        $tmp3[] = array('name' => $name, 'code' => strtoupper($code));
      }
    return $tmp3;
  }


  public function autoload($classname)
  {
    $ret = parent::autoload($classname);
    if( $ret ) return;

    $dirs = array();
    $dirs[] = $this->GetModulePath().'/lib/reports';
    
    foreach( $dirs as $onedir )
      {
	$fn = $onedir."/class.{$classname}.php";
	if( file_exists($fn) )
	  {
	    require_once($fn);
	    return TRUE;
	  }
      }

    return FALSE;
  }
} // class

#
# EOF
#
?>
