<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgfav_ops
{
  protected function __construct() {}

  protected static function &load_from_data($row)
  {
    if( !is_array($row) || !isset($row['uid']) || !isset($row['key1']) ) return;

    $obj = new cgfav;
    foreach( $row as $key => $value )
      {
	$obj->$key = $value;
      }
    return $obj;
  }


  public static function &load_one($uid,$key1,$key2 = null,$key3 = null,$key4 = null)
  {
    if( $uid == '' || $key1 == '' ) return;

    $parms = array();
    $parms[] = $uid;
    $parms[] = $key1;
    $query = 'SELECT * FROM '.CGFAVS_TABLE.' WHERE uid = ? AND key1 = ?';
    if( $key2 )
      {
	$parms[] = $key2;
	$query .= ' AND key2 = ?';
	if( $key3 )
	  {
	    $parms[] = $key3;
	    $query .= ' AND key3 = ?';
	    if( $key4 )
	      {
		$parms[] = $key4;
		$query .= ' AND key4 = ?';
	      }
	  }
      }

    $db = cmsms()->GetDb();
    $row = $db->GetRow($query,$parms);
    if( !$row ) return;

    $obj = self::load_from_data($row);
    return $obj;
  }


  public static function insert(cgfav& $obj)
  {
    if( $obj->id != '' )
      {
	throw new Exception('Logic Error... cannot insert a record with a valid id');
      }

    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.CGFAVS_TABLE.' (uid,key1,key2,key3,key4,comment,data,created,modified)
               VALUES (?,?,?,?,?,?,?,NOW(),NOW())';
    $dbr = $db->Execute($query,array($obj->uid,$obj->key1,$obj->key2,$obj->key3,$obj->key4,$obj->comment,$obj->data));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
    $obj->id = $db->Insert_ID();
  }


  public static function update(cgfav& $obj)
  {
    if( $obj->id <= 0 )
      {
	throw new Exception('Logic Error... cannot update a record without a valid id');
      }

    // we do no checking here
    $db = cmsms()->GetDb();
    $where = array();
    $parms = array();
    $parms[] = $obj->comment;
    $parms[] = $obj->data;
    $where[] = 'id = ?';
    $parms[] = $obj->id;
    $where[] = 'uid = ?';
    $parms[] = $obj->uid;
    $tmp = array('key1','key2','key3','key4');
    foreach( $tmp as $key )
      {
	if( $obj->$key )
	  {
	    $where[] = "$key = ?";
	    $parms[] = $obj->$key;
	  }
	else
	  {
	    $where[] = "$key IS NULL";
	  }
      }
    $query = 'UPDATE '.CGFAVS_TABLE.' SET comment = ?, data = ?, modified = NOW()';
    $query .= ' WHERE '.implode(' AND ',$where);
    $dbr = $db->Execute($query,$parms);
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
    $obj->modified = $db->DbTimeStamp(time());
  }


  static public function delete(cgfav& $obj)
  {
    if( $obj->id <= 0 )
      {
	throw new Exception('Logic Error... cannot delete a record without a valid id');
      }

    $parms = array($obj->id,$obj->uid,$obj->key1);
    $query = 'DELETE FROM '.CGFAVS_TABLE.' WHERE id = ? AND uid = ? AND key1 = ?';
    if( !is_null($obj->key2) )
      {
	$parms[] = $obj->key2;
	$query .= ' AND key2 = ?';
	if( !is_null($obj->key3) )
	  {
	    $parms[] = $obj->key3;
	    $query .= ' AND key3 = ?';
	    if( !is_null($obj->key4) )
	      {
		$parms[] = $obj->key4;
		$query .= ' AND key4 = ?';
	      }
	  }
      }
    $db = cmsms()->GetDb();
    $dbr = $db->Execute($query,$parms);
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
  }


  static public function bulk_delete($uid,$idlist)
  {
    if( !$uid || !is_array($idlist) )
      {
	throw new Exception('Invalid parameters');
      }

    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGFAVS_TABLE.' WHERE uid = ? AND id IN ('.implode(',',$idlist).')';
    $dbr = $db->Execute($query,array($uid));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
  }


  static public function get($uid,$key1 = '',$key2 = '',$key3 = '')
  {
    $db = cmsms()->GetDb();
    $parms = array($uid);
    $query = 'SELECT * FROM '.CGFAVS_TABLE.' WHERE uid = ?';
    if( $key1 )
      {
	$query .= ' AND key1 = ?';
	$parms[] = $key1;

	if( $key2 )
	  {
	    $query .= ' AND key2 = ?';
	    $parms[] = $key2;

	    if( $key3 )
	      {
		$query .= ' AND key3 = ?';
		$parms[] = $key3;
	      }
	  }
      }

    $tmp = $db->GetArray($query,$parms);
    if( !is_array($tmp) ) return;

    $res = array();
    for( $i = 0; $i < count($tmp); $i++ )
      {
	$res[] = self::load_from_data($tmp[$i]);
      }
    return $res;
  }


  static public function load_users($key1,$key2 = '',$key3 = '',$key4 = '')
  {
    $parms = array($key1);
    $query = 'SELECT DISTINCT uid FROM '.CGFAVS_TABLE.' WHERE key1 = ?';
    if( $key2 )
      {
	$parms[] = $key2;
	$query .= ' AND key2 = ?';
	if( $key3 )
	  {
	    $parms[] = $key3;
	    $query .= ' AND key3 = ?';
	    if( $key4 )
	      {
		$parms[] = $key4;
		$query .= ' AND key4 = ?';
	      }
	  }
      }

    $db = cmsms()->GetDb();
    $dbr = $db->GetCol($query,$parms);
    if( !$dbr )
      {
  	throw new Exception('Query Failed '.$db->sql);
      }

    return $dbr;
  }


  static public function find_users($users,$key1 = '',$key2 = '',$key3 = '',$key4 = '')
  {
    $query = 'SELECT DISTINCT uid FROM '.CGFAVS_TABLE.' WHERE uid';
    if( is_array($users) )
      {
	for( $i = 0; $i < count($users); $i++ )
	  {
	    $users[$i] = "'".$users[$i]."'";
	  }
	$query .= ' IN ('.implode(',',$users).' ) ';
      }
    else
      {
	$query .= " = '{$users}'";
      }

    $parms = array();
    if( $key1 )
      {
	$query .= ' AND key1 = ?';
	$parms[] = $key1;
      }
    if( $key2 )
      {
	$query .= ' AND key2 = ?';
	$parms[] = $key2;
      }
    if( $key3 )
      {
	$query .= ' AND key3 = ?';
	$parms[] = $key3;
      }
    if( $key4 )
      {
	$query .= ' AND key4 = ?';
	$parms[] = $key4;
      }

    $db = cmsms()->GetDb();
    $dbr = '';
    if( count($parms) )
      {
	$dbr = $db->GetCol($query,$parms);
      }
    else
      {
	$dbr = $db->GetCol($query);
      }

    return $dbr;
  }
} // end of class

#
# EOF
#
?>