<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfav_cat_ops
{
  public function __construct() {}

  protected static function &load_from_data($rec)
  {
    if( !is_array($rec) ) return;
    if( !isset($rec['name']) || !isset($rec['id']) ) return;
    
    $obj = new cgfav_cat();
    $obj->id = $rec['id'];
    $obj->sorting = $rec['sorting'];
    $obj->name = $rec['name'];
    return $obj;
  }


  public static function get_all()
  {
    $query = 'SELECT * FROM '.CGFAVS_CATS_TABLE.' ORDER BY sorting';
    $db = cmsms()->GetDb();

    $data = $db->GetArray($query);
    if( !is_array($data) ) return;

    $output = array();
    for( $i = 0; $i < count($data); $i++ )
      {
	$output[] = self::load_from_data($data[$i]);
      }
    return $output;
  }


  public static function &load_by_name($name)
  {
    $res = null;
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGFAVS_CATS_TABLE.' WHERE name = ?';
    $row = $db->GetRow($query,array($name));
    if( !$row || !is_array($row)) return $res;

    return self::load_from_data($row);
  }


  public static function &load_by_id($id)
  {
    $res = null;
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGFAVS_CATS_TABLE.' WHERE id = ?';
    $row = $db->GetRow($query,array($id));
    if( !$row || !is_array($row)) return $res;

    return self::load_from_data($row);
  }


  public static function &load_by_sorting($id)
  {
    $res = null;
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.CGFAVS_CATS_TABLE.' WHERE sorting = ?';
    $row = $db->GetRow($query,array($id));
    if( !$row || !is_array($row)) return $res;

    return self::load_from_data($row);
  }


  public static function insert(cgfav_cat& $cat)
  {
    if( $cat->id > 0 )
      {
	throw new Exception('Logic Error... cannot insert a record with a valid id');
      }

    // first find the next sort order.
    $db = cmsms()->GetDb();
    $query = 'SELECT MAX(sorting) FROM '.CGFAVS_CATS_TABLE;
    $sorting = $db->GetOne($query);
    if( $sorting ) $sorting++;
    $sorting = max($sorting,1);
    $cat->sorting = $sorting;

    $query = 'INSERT INTO '.CGFAVS_CATS_TABLE.' (name,sorting) VALUES (?,?)';
    $dbr = $db->Execute($query,array($cat->name,$sorting));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }

    $cat->id = $db->Insert_ID();
  }


  public static function update(cgfav_cat& $cat)
  {
    if( $cat->id <= 0 )
      {
	throw new Exception('Logic Error... cannot update a record without a valid id');
      }

    // we do no checking here.
    $db = cmsms()->GetDb();
    $query = 'UPDATE '.CGFAVS_CATS_TABLE.' SET name = ?, sorting = ? WHERE id = ?';
    $dbr = $db->Execute($query,array($cat->name,$cat->sorting,$cat->id));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
  }


  public static function delete(cgfav_cat& $cat)
  {
    if( $cat->id <= 0 )
      {
	throw new Exception('Logic Error... cannot update a record without a valid id');
      }

    $db = cmsms()->GetDb();
    $query = 'DELETE FROM '.CGFAVS_CATS_TABLE.' WHERE Id = ?';
    $dbr = $db->Execute($query,array($cat->id));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }

    $query = 'UPDATE '.CGFAVS_CATS_TABLE.' SET sorting = sorting - 1 WHERE sorting > ?';
    $dbr = $db->Execute($query,array($cat->sorting));
    if( !$dbr )
      {
	throw new Exception('Query Failed '.$db->sql);
      }
  }
} // end of class

#
# EOF
#
?>