<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfav extends friendly
{
  private $_data = array();

  public function __construct()
  {
    $this->add_friend('cgfav_ops');
  }

  public function __get($key)
  {
    if( !in_array($key,array('id','uid','key1','key2','key3','key4','category','comment','created','modified','data','value')) )
      {
	throw new Exception('Attempt to retrieve an invalid member of a cgfav object');
      }

    if( isset($this->_data[$key]) )
      return $this->_data[$key];
  }


  public function __set($key,$value)
  {
    if( !in_array($key,array('id','created','modified','uid','key1','key2','key3','key4','category','comment','data','value')) )
      {
	throw new Exception('Attempt to set an invalid member of a cgfav object');
      }

    $this->_data[$key] = $value;
  }


  public function save()
  {
    if( $this->id == '' )
      {
	cgfav_ops::insert($this);
      }
    else
      {
	cgfav_ops::update($this);
      }
  }

  
  public function delete()
  {
    cgfav_ops::delete($this);
  }


  public function to_array()
  {
    return $this->_data;
  }
} // end of class

#
# EOF
#
?>