<?php

#A
$lang['addtofav_template'] = 'Add-To-Favorites Form Templates';
$lang['add_category'] = 'Add a New Category';

#B

#C
$lang['cancel'] = 'Cancel';
$lang['categories'] = 'Categories';
$lang['created'] = 'Created';

#D
$lang['default_templates'] = 'Default Templates';

#E
$lang['edit_category'] = 'Edit Category';
$lang['error_missingparam'] = 'A required parameter is missing';
$lang['error_nameexists'] = 'An item by that name already exists';
$lang['error_namerequired'] = 'You must supply a name for this item';
$lang['error_notfound'] = 'Could not find the requested item';
$lang['error_operationfailed'] = 'Operation Failed';
$lang['eventdesc_OnAddFavorite'] = 'Sent after a favorite is added or removed';
$lang['eventdesc_OnEditFavorites'] = 'Sent after a user modifies their favorites list';
$lang['eventhelp_OnAddFavorite'] = '<p>Sent when a favorite is added or removed.</p>
<h4>Parameters</h4>
<ul>
  <li>"fav" - The favorite object that was updated.</li>
</ul>';
$lang['eventhelp_OnEditFavorites'] = '<p>Sent after a user midifies their favorites list.</p>
<h4>Parameters:</h4>
<ul>
  <li>"favorites" - An array of favorite objects representing the users current list of favorites.</li>
</ul>';

#F
$lang['friendlyname'] = 'Calguys Favorites Manager';

#G

#H
$lang['help'] = <<<EOT
<h3>What Does This Do?</h3>
<p>This module allows your site visitors to manage and share their own list of &quot;Favorites&quot;.  These favorites can be any items (Products, Comments, Blog Posts, News articles, Pages, etc).  When combined with an authentication mechanism such as Facebook this module allows seeing what other friends are using the application, and what they have used to their favorites list.  This is a fantastic way to keep visitors on your site, and to gain statistics about popular things on your site.   A must have for any e-commerce or resource site.</p>
<h3>Features</h3>
<ul>
<li>Flexibility.  This module works simply by storing identifiers.  Therefore you can use it with the Products module, Content pages, a news articles, or all of the above.</li>
<li>User - Agnostic:  This module does NOT rely on the FrontEndUsers module.  All that is needed is an identifier that is unique identifier for a user.  Facebook User IDs are great for this.</li>
<li>completely template driven.  All of the forms are smarty driven.</li>
</ul>
<h3>How do I use it</h3>
<p>The usage of this module usually requires many steps.  And may require the use of other modules (such as FrontEndUsers or CGFBApp for facebook integration in order to acquire a unique user id.). Some of the steps required are:</p>
<ul>
  <li>Allow user to authenticate, and retrieve the unique user identifier:
    <ul>
       <li>with FrontEndUsers and CustomContent:
         <pre>{FrontEndUsers}{assign var='<span style="color:blue;">uid</span>' value=\$ccuser->loggedin()}</pre>
       </li>
       <li>with CGFBApp:
         <pre>{cgfb_login}{cgfb_uid assign='<span style="color:blue;">uid</span>'}</pre>
       </li>
    </ul>
    <p></p>
  </l>
  <li>Allow users to add items to their favorites list.
    <ul>
      <li>i.e: Placing this tag in your Products module summary template:
      <pre>{if \$uid}{CGFavs uid=<span style="color:blue;">\$uid</span> key1='Products' key2=\$entry->id postaction='url'}{/if}</pre>
      <p>This will provide a simple form that allows the user to add this item to their favorites list... or infact to remove it from their list. Note that we are providing a series of &quot;keys&quot; to the module. These keys are used to uniquely identify an item to be added to the list.  In this case we need two keys.  The first is the module name <em>(Products)</em>.  The second is the unique product id.  The last argument &quot;postaction&quot; is used to to indicate the action to take once the form has been submitted.  This argument will be described further below.</p>
        </p>
      </li>
    </ul>
  </lI>
  <li>Display the users that have listed items in their favorites list:
   <ul>
     <li>Sometimes it is useful to display statistical information about how many people have added an item to their favorites list.  This can be done with the &quot;users&quot; action. i.e:</li>
   <pre>{CGFavs action='users' key1='Products' key2=\$entry->id assign='users'}</pre>
   <p>Yhis action will return an array of ALL of the user ids that have added this item to their favorites.  You can then count these items, or whatever you would like to do.  i.e: {\$users|@count} users count this item as a favorite.</p>
    </ul>
  </li>
  
  <li>Allow users to view and manage their favorites.</li>
    <ul>
   <li>Users need to be able to displaya list of their favorites, and to manage that list.  This is done with an action like:
       <pre>{CGFavs action='myfavorites' uid=<span style="color: blue;">\$uid</span> postaction='inline'}</pre>
       <p>This will use the myfavorites template that is editable within the CGFavs admin panel.  This template will require modifications in order to display things the way you want them.   The sample template that comess with CGFavs illustrates how to differentlate between the keys and to call the different modules.</p>
     </li>
    </ul>
  </li>

  <li>Allow users to view a list of their friends that have added favorites.</li>
    <ul>
       <li>It is often useful to advertise to an <em>(already authenticated)</em> user which of his friends have visited the site and are managing a favorites list.  The FrontEndUsers module has no concept of &quot;friends&quot; built in.  However the CGFBApp module allows retrieving the friends list of the currently logged in user.  This friends list must be retrieved and supplied to the CGFavs module.
       <pre>{cgfb_api call='/me/friends' assign='friends'}{CGFavs action='listfriends' friends=\$friends assign='friendswithfavs'}</pre>
       <p>This will return an array of the currently logged in facebook users freinds who have also created favorites in this webiste.  The developer should iterate through this list, request the information for each of these users, and build a display of them.</p>
      </li>
    </ul>
  </li>

  <li>Allow users to view the favorites of their friends.
    <ul>
       <li>This is a trivial exercise of retrieivng the list of friends that use the application, and then for each of them retrieving the favorites for that user. i.e:
          <pre><br/>{cgfb_api call='/me/friends' assign='friends'}{CGFavs action='listfriends' friends=\$friends action='friendswithfavs'}
{if \$friendswithfavs}
&lt;ul class="friendslist"&gt;
{foreach from=\$friendswithfavs item='friend'}
&lt;li&gt;
  {CGFavs action='myfavorites' uid=\$friend mftemplate='specialtemplate'}
&lt;/li&gt;
{/foreach}
&lt;/ul&gt;
{/if}
          </pre>
       </li>
    </ul>
  </li>
</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy\'s
module homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>
EOT;

#I
$lang['info_addtofav_tpl'] = 'Template used to display a form allowing a visitor to add an item to their favorites list';
$lang['info_myfavs_tpl'] = 'Template used to display a form allowing a visitor to manage their favorites list';

#J

#K

#L

#M
$lang['moddescription'] = 'Allow visitors to store manage bookmarks';
$lang['move_down'] = 'Move Down';
$lang['move_up'] = 'Move Up';
$lang['myfavs_template'] = 'My-Favorites Templates';

#N
$lang['name'] = 'Name';

#O

#P
$lang['param_aftemplate'] = 'Applicable to the default action, this parameter allows specifying by name an &quots;Add to Favorites&quot; template that is not the default';
$lang['param_friends'] = 'Applicable to the listfriends action, this parameter allows specifying an array of friend IDs';
$lang['param_mftemplate'] = 'Applicable to the myfavorites action, this parameter allws specifying by name a &quot;My Favorites&quot; template that is not the default.';
$lang['param_category'] = 'Specify an optional category to assign to the favorite.  Applicable to the default action, this parameter can be used to categorize the favorites. for later statistics and grouping';
$lang['param_key1'] = 'Used with the default action, this parameter provides the ability to uniquely identify the item';
$lang['param_key2'] = 'Used with the default action, this parameter provides the ability to uniquely identify the item';
$lang['param_key3'] = 'Used with the default action, this parameter provides the ability to uniquely identify the item';
$lang['param_key4'] = 'Used with the default action, this parameter provides the ability to uniquely identify the item';
$lang['param_url'] = 'Applicable in the default and myfavorites actions when the postaction=origurl, this parameter specifies the url to redirect to.';
$lang['param_page'] = 'Applicable in the default view when the postaction=page, this parameter specifies the page alias to redirect to.';
$lang['param_postaction'] = 'Applicable to the default and myfavorites actions, this parameter allows specifying what to do when the form has complted.  Possible values are:
  <ul>
    <li>url - redirect to the URL specified by the origurl parameter.  If not specified, use the original url.</li>
    <li>inline  - does not redirect and will result in the form being displayed again.</li>
    <li>page - Redirect to the page alias specified in the page paremeter.</li>
  </ul>
';
$lang['param_uid'] = 'Applicable to the default and myfavorites actions, this parameter is required, and is used to uniquely identify the user.';
$lang['postinstall'] = 'The CGFavs module is installed, please check out this modules admin panel';
$lang['postuninstall'] = 'The CGFavs module and all associated data has been removed';
$lang['preuninstall'] = 'Are you sure you want to procede?  All bookmarks and favorites generated by visitors will be deleted!';

#Q

#R

#S
$lang['submit'] = 'Submit';

#T
$lang['title_addtofav_tpl'] = 'Add-To-Favorties Form Template';
$lang['title_myfavs_tpl'] = 'My-Favorites Form Template';
$lang['title_sysdflt_addtofav'] = 'System Default Add-To-Favorites Form Template';
$lang['title_sysdflt_myfavs'] = 'System Default My Favorites Form Template';

#U
$lang['update'] = 'Update';

#V

#W

#X

#Y

#Z

?>