<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialize
//
$inline = false;
$uid = '';
$key1 = '';
$key2 = '';
$key3 = '';
$postaction = '';
$the_template = $this->GetPreference(CGFavs::PREF_DFLT_MYFAVS);
$fav_obj = null;
if( !isset($params['uid']) )
  {
    $this->DisplayErrorMessage($this->Lang('error_missingparam'));
    return;
  }

//
// setup
//
$uid = trim($params['uid']);
$key1 = get_parameter_value($params,'key1',null);
$key2 = get_parameter_value($params,'key2',null);
$key3 = get_parameter_value($params,'key3',null);
$postaction = get_parameter_value($params,'postaction',$postaction);
$the_template = get_parameter_value($params,'mftemplate',$the_template);
$favs = cgfav_ops::get($uid,$key1,$key2,$key3);

//
// handle form actions
//
if( isset($params['submit']) )
  {
    if( isset($params['remove']) )
      {
	cgfav_ops::bulk_delete($uid,$params['remove']);
	$favs = cgfav_ops::get($uid,$key1,$key2,$key3);
      }

    $this->SendEvent('OnEditFavorites',array('favorites'=>$favs));

    switch( $postaction )
      {
      case 'url':
	$url = get_parameter_value($params,'url',cge_url::current_url());
	if( $url ) redirect($url);
	break;

      case 'page':
	$alias = get_parameter_value($params,'page',null);
	if( $alias ) $this->RedirectContent($alias);
	break;

      case 'inline':
	// do nothing
	break;

      case 'nothing':
      default:
      }
  }


//
// give everything to smarty
//
if( $favs ) 
  {
    $data = array();
    for( $i = 0; $i < count($favs); $i++ )
      {
	$rec = $favs[$i]->to_array();
	$data[] = $rec;
      }
    $smarty->assign('favs',$data);
  }
$smarty->assign('formstart',$this->CGCreateFormStart($id,'myfavorites',$returnid,$params,($postaction == 'inline')));
$smarty->assign('formend',$this->CreateFormEnd());
echo $this->ProcessTemplateFromDatabase('myfavs_'.$the_template);

#
# EOF
#
?>